"""Driver script for solving the 1D Euler equations using a WENO scheme"""

import numpy as np
import matplotlib.pyplot as plt
from EulerWeno import *
from Legendre import LegendreGQ

# Order of the method
m = 2

# Set problem parameters
CFL = 0.9
FinalTime = 0.2
N = 256
gamma = 1.4

q = np.zeros((3,N+1))

# Initialize for Sod's problem - piecewise constant so no integration
L = 1.0
h = L/N
x = np.linspace(0.0, L, N+1)

for i in range(N+1):
	if x[i] < 0.5:
		q[0,i] = 1.0
		q[2,i] = 1.0/(gamma-1)
	else:
		q[0,i] = 0.125
		q[2,i] = 0.1/(gamma-1)

# # Initialize for shock entropy problem
# L = 10.0
# h = L/N
# x = np.linspace(-5.0, 5.0, N+1)

# NGQ = 10
# xGQ,wGQ = LegendreGQ(NGQ)

# for i in range(N+1):
# 	if x[i] < -4.0:
# 		rh = 3.857143
# 		u = 2.629369
# 		p = 10.33333
# 		q[0,i] = 1.0
# 		q[2,i] = 1.0/(gamma-1)
# 	else:
# 		rh = 0.0
# 		for j in range(NGQ+1):
# 			rh += wGQ[j]*(1.0+0.2*np.sin(np.pi*(x[i]+h/2*xGQ[j])))
# 		rh /= 2
# 		u = 0.0
# 		p = 1.0
# 	q[:,i] = np.array([rh, rh*u, p/(gamma-1)+0.5*rh*u**2])


# Solve Problem
q = EulerWENO1D(x,q,h,m,CFL,gamma,FinalTime)

# Plot
plt.plot(x,q[0,:])
plt.title("Solution rho at time {}".format(FinalTime))
plt.show()