"""Driver script for solving the 1D Euler equations using a WENO scheme"""

import numpy as np
import matplotlib.pyplot as plt
from EulerSpec import *

# Set problem parameters
CFL = 1.0
FinalTime = 0.2
N = 512
gamma = 1.4
xmin = -1.0
xmax = 1.0

# Define domain and initial conditions
L = xmax-xmin
x = xmin + L/(2*N+1)*np.arange(2*N+1)

# Define domain,materials and initial conditions
q = np.zeros((3,2*N+1))

# Initialize for Sod's problem
q[0,:] = 1.0*(np.abs(x)>0.5) + 0.125*(np.abs(x)<=0.5)
q[2,:] = (1.0*(np.abs(x)>0.5) + 0.1*(np.abs(x)<=0.5))/(gamma-1.0)

# Solve Problem
q = EulerSpec1D(x,q,N,L,CFL,gamma,FinalTime)

# Plot
plt.plot(x,q[0,:])
plt.title("Solution rho at time {}".format(FinalTime))
plt.show()