"""Driver script for solving the 1D Euler equations using a slope limited scheme """

import numpy as np
import matplotlib.pyplot as plt
from EulerSlopeLimit import *

# Set problem parameters
FinalTime = 0.2
N = 1024
CFL = 0.9
gamma = 1.4

# Define domain, materials and initial conditions
q = np.zeros((3,N+1))

# Initialize for Sod's problem
L = 1.0
h = L/N
x = np.linspace(0.0,1.0,N+1)
for i in range(N+1):
    if (x[i] < 0.5):
        q[0,i] = 1.0
        q[2,i] = 1/(gamma-1)
    else:
        q[0,i] = 0.125
        q[2,i] = 0.1/(gamma-1)

# # Initialize for shock entropy problem
# L = 10.0
# h = L/N
# x = np.linspace(-5.0,5.0,N+1)
# for i in range(N+1):
#     if x[i] < -4.0:
#         rh = 3.857143; u = 2.629369; p = 10.33333;  
#     else:
#         rh = 1+0.2*np.sin(np.pi*x[i]); u = 0; p = 1;

#     q[0,i] = rh
#     q[1,i] = rh*u
#     q[2,i] = p/(gamma-1)+0.5*rh*u**2

# Solve problem
q = EulerSL1D(x,q,h,CFL,gamma,FinalTime)

plt.plot(x,q[0,:])
plt.title("Solution rho at time {}".format(FinalTime))
plt.show()