"""Driver script for solving the 2D Burgers equations using a WENO scheme"""

import numpy as np
import matplotlib.pyplot as plt
from BurgersWeno import *

# Order of the method
m = 2

# Set problem parameters
Lx = 1.0
Ly = 1.0
CFL = 0.9
FinalTime = 0.1
Nx = 64
Ny = 64
hx = Lx/Nx
hy = Ly/Ny

# Define domain and initial conditions
xv = np.linspace(0.0, Lx, Nx+1)
yv = np.linspace(0.0, Ly, Ny+1)
[x,y] = np.meshgrid(xv, yv)
u = np.sin(4*np.pi*(x+y/2))

# Solve Problem
u = BurgersWENO2D(x,y,u,hx,hy,m,CFL,FinalTime)

# Plot
plt.contour(x,y,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()
