"""Driver script for solving the 2D Burgers equation using a monotone scheme"""

import numpy as np
import matplotlib.pyplot as plt
from BurgersMonotone import *

# Set problem parameters
Lx = 1.0
Ly = 1.0
Nx = 256
Ny = 256
hx = Lx/Nx
hy = Ly/Ny
CFL = 0.9
FinalTime = 0.1

# Define domain and initial conditions
_x = np.linspace(0.0,1.0,Nx+1)
_y = np.linspace(0.0,1.0,Ny+1)
x,y = np.meshgrid(_x,_y)
u = np.sin(4*np.pi*(x+y/2)) 

# Solve problem
u = BurgersM2D(x,y,u,hx,hy,CFL,FinalTime)

# Plot
plt.contour(x,y,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()