"""Driver script for solving the 1D Burgers equations using a DG scheme"""

import numpy as np
import matplotlib.pyplot as plt
from BurgersDG import *
from Legendre import LegendreGL

# Order of the method (m), number of elements (N)
m = 1
N = 40

# Set problem parameters
xmin = 0.0
xmax = 1.0
CFL = 0.1
FinalTime = 0.5

# Generate mesh
VX = xmin + (xmax-xmin)/N*np.arange(N+1)
r,w = LegendreGL(m)
x = np.outer( np.ones(m+1), VX[:N] ) + 0.5*np.outer(r+1.0, VX[1:N+1] - VX[:N] )
h = (xmax-xmin)/N

# Define initial conditions
u = np.sin(2*np.pi*x) + 0.8 # periodic BC needed
# u = (1.0 - np.sign(x-0.2))/2 + 1 # Constant BC needed

# Solve Problem
u = BurgersDG1D(x,u,h,m,N,CFL,FinalTime)

# Plot
plt.plot(x[0,:],u[0,:])
plt.title("Solution u at time {}".format(FinalTime))
plt.show()

