# Driver script for solving the 2D Burgers equations using second order central scheme

import numpy as np
import matplotlib.pyplot as plt
from BurgersCentral import *

# Set problem parameters
Lx = 1.0
Ly = 1.0
Nx = 128
Ny = 128
hx = Lx/Nx
hy = Ly/Ny
FinalTime = 0.1
CFL = 0.9

# Define domain and initial conditions
_x = np.linspace(0.0,1.0,Nx+1)
_y = np.linspace(0.0,1.0,Ny+1)
x,y = np.meshgrid(_x, _y)
u = np.sin(4*np.pi*(x+y/2)) #periodic BC needed

# Solve problem
u = BurgersC2D(x, y, u, hx, hy, CFL, FinalTime)


# Plot
plt.contour(x,y,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()
