"""Driver script for solving the 1D Burgers equations using second order central scheme"""

import numpy as np
import matplotlib.pyplot as plt
from BurgersCentral import *

# Set problem parameters
L = 1.0
FinalTime = 0.2
N = 512
h = L/N
CFL = 0.9

# Define domain and initial conditions
x = np.linspace(0.0,1.0,N+1)
u = np.sin(2*np.pi*x) # periodic BC needed
# u = (1.0-np.sign(x-0.2))/2.0+1.0 # Constant BC needed

# Solve problem
u = BurgersC1D(x, u, h, CFL, FinalTime)

# Plot
plt.plot(x,u)
plt.title("Solution u at time {}".format(FinalTime))
plt.show()



