function [sd] = Test_single_PhaseRetrieval_Nystrom(r, field, model)
%This script runs an experimental instance using a complex psd matrix 
%obtained from a real-world phase retrieval application. See Section 5 in 
%[TYUC2017Nys] for details.
%	Inputs: r		-> target rank
% 			field 	-> field for the test matrices: 'complex' or 'real'.
%           model   -> model for the test matrices: 'orthonormal' or 'ssft'
%	Output: sd		-> structure with following fields
%						* ErrBest_S2 ,ErrBest_S1, ErrBest_Sinf
%						* info, k, l, ID
%						* ErrA9_S2, ErrNy_S2, ErrGM_S2
%						* ErrA9_S1, ErrNy_S1, ErrGM_S1
%						* ErrA9_Sinf, ErrNy_Sinf, ErrGM_Sinf
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 12, 2017
%   Last modified: October 22, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys?-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% Add some utilities to the path
% We add 'updateThinSVD' function that computes the sum of two low-rank
% matrices directly using their singular value decompositions
addpath utils

%% Generate test setup and/or load data

if strcmp(field,'real')
    alpha = 1;
    beta = 1;
elseif strcmp(field,'complex')
    alpha = 0;
    beta = 2;
else
    error('''field'' should be ''real'' or ''complex''.')
end

load('data/FourrierPtychographyData.mat');
U = info.U;
Z = info.Z;
Z = Z./Z(1);
Zd = diag(Z);
m = info.n;
n = m;
clearvars info

% Find best rank-r errors
ErrBest_S2 = norm(Zd((r+1):end));
ErrBest_S1 = norm(Zd((r+1):end),1);
ErrBest_Sinf = norm(Zd((r+1):end),inf);

%% Run the generic test file
TestGeneric_kl_Type2_Nystrom;

end
