function [sd] = Test_single_LowRankPlusNoise_Nystrom(n,r,R,noiseLevel,field,model)
%This script runs an experimental instance using a matrix from the low rank 
%plus noise class. See Section 5 in [TYUC2017Nys] for details.
%	Inputs: n       -> dimension of matrix (n x n)
%           r		-> target rank
%			R		-> effective rank
%			noiseLevel	->  'LowNoise' (low noise) 
%							'MedNoise' (medium noise) 
%							'HiNoise'  (high noise)
% 			field 	-> field for the test matrices: 'complex' or 'real'.
%           model   -> model for the test matrices: 'orthonormal' or 'ssft'
%	Output: sd		-> structure with following fields
%						* ErrBest_S2 ,ErrBest_S1, ErrBest_Sinf
%						* info, k, l, ID
%						* ErrA9_S2, ErrNy_S2, ErrGM_S2
%						* ErrA9_S1, ErrNy_S1, ErrGM_S1
%						* ErrA9_Sinf, ErrNy_Sinf, ErrGM_Sinf
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 12, 2017
%   Last modified: October 22, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

dataname = ['data/Nystrom_LowRank',noiseLevel,'_n',num2str(n),'_R',num2str(R),'.mat'];

if ~exist(dataname,'file')
    error(['Data file not found: Before go to the data folder and run ' ... 
    '''CreateData.m'' file to generate a dataset for noisy low-rank' ...
    'model before running this script.']);
end
load(dataname)

ErrBest_S2 = norm(singVals(r+1:end));
ErrBest_S1 = norm(singVals(r+1:end),1);
ErrBest_Sinf = norm(singVals(r+1:end),inf);

%% Run the generic test file
TestGeneric_kl_Type1_Nystrom;

end