function [sd] = Test_single_ExpDecay_Nystrom(n,r,R,q,field,model)
%This script runs an experimental instance using a matrix with exponential 
%decay in the spectrum. See Section 5 in [TYUC2017Nys] for details.
%	Inputs: n 		-> size of input matrix (n x n)
%			r		-> target rank
%			R		-> effective rank
%			q		-> parameter that controls the rate of decay
% 			field 	-> field for the test matrices: 'complex' or 'real'.
%           model   -> model for the test matrices: 'orthonormal' or 'ssft'
%	Output: sd		-> structure with following fields
%						* ErrBest_S2 ,ErrBest_S1, ErrBest_Sinf
%						* info, k, l, ID
%						* ErrA9_S2, ErrNy_S2, ErrGM_S2
%						* ErrA9_S1, ErrNy_S1, ErrGM_S1
%						* ErrA9_Sinf, ErrNy_Sinf, ErrGM_Sinf
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 12, 2017
%   Last modified: October 22, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.


%% Create or load data

% Generate the matrix A
Sigma(1:R) = 1;
Sigma((R+1):n) = 10.^(-q*((1:(n-R))+1));
% Sigma = ((1:min(m,n)).^(-p)).';
A = diag(Sigma+0*1i);
% Find the ground truth (best rank-r approximation)
ErrBest_S2 = norm(Sigma(r+1:end));
ErrBest_S1 = norm(Sigma(r+1:end),1);
ErrBest_Sinf = norm(Sigma(r+1:end),inf);

%% Run the generic test file
TestGeneric_kl_Type1_Nystrom;

end