function [dummy] = Test_parfor_PolyDecay_Nystrom(n,r,R,p,field,model,MonteCarloNum)
%This function runs Monte Carlo simulations in a parfor loop.
%
%   See our reference paper for the detailed explanation of the
%   sketching procedure and the arithmetic, communication and storage
%   costs.
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 12, 2017
%   Last modified: October 22, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% Beginning of the test

MCresults = cell(MonteCarloNum,1);

parfor tt = 1:MonteCarloNum
    MCresults{tt} = Test_single_PolyDecay_Nystrom(n,r,R,p,field,model);
end

name = ['n',num2str(n),'_r',num2str(r),'_R',num2str(R),'_p',num2str(p),'_',field,'_',model,'/'];
savepath = ['results/NystromSketch/',mfilename,'/',name];
if ~exist(savepath,'dir'), mkdir(savepath); end
filename = datestr(now,30);
save([savepath,filename],'-v7.3','MCresults');

dummy = 1;

end