%   This script plots the Figures with Schatten-inf error in [TYUC2017Nys].
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: October 24, 2017
%   Last modified: October 24, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% Colors and more
cAlgNy   = [.6,.6,.6];
cAlgNy2   = [0,0,0];

cAlg9    = [.95,.5,.35];
cAlg92    = [.7,.2,0];

cAlgGM   = [.6,.85,1];
cAlgGM2   = [.2,.7,.9];

%% First test: Test_parfor_IdentityMatrix
for rr = 1:length(experiment)
    clearvars Err*
    dname_ortho = dir(['results/NystromSketch/',experiment{rr},'_orthonormal/*.mat']);
    dname_ssft = dir(['results/NystromSketch/',experiment{rr},'_ssft/*.mat']);
    ortho = load(['results/NystromSketch/',experiment{rr},'_orthonormal/',dname_ortho.name]);
    ssft = load(['results/NystromSketch/',experiment{rr},'_ssft/',dname_ssft.name]);

    %% Compute ORTHONORMAL results
    numMonteCarlo = length(ortho.MCresults);
    numDataPoint  = length(ortho.MCresults{1}.info.T);
    
    for ll = 1:numMonteCarlo
        for tt = 1:numDataPoint
            ortho.ErrNy_SinfMin(ll,tt)     = min(ortho.MCresults{ll}.ErrNy_Sinf{tt})     /   ortho.MCresults{ll}.ErrBest_Sinf     -   1; 
            if isempty(ortho.MCresults{ll}.ErrA9_Sinf{tt}), ortho.MCresults{ll}.ErrA9_Sinf{tt} = nan; end
            ortho.ErrA9_SinfMin(ll,tt)     = min(ortho.MCresults{ll}.ErrA9_Sinf{tt})     /   ortho.MCresults{ll}.ErrBest_Sinf     -   1; % minimum over all (k,l) pairs
            if isempty(ortho.MCresults{ll}.ErrGM_Sinf{tt}), ortho.MCresults{ll}.ErrGM_Sinf{tt} = nan; end
            ortho.ErrGM_SinfMin(ll,tt)     = min(ortho.MCresults{ll}.ErrGM_Sinf{tt})     /   ortho.MCresults{ll}.ErrBest_Sinf     -   1; 
        end
    end
    
    % Compute average relative error over all Monte Carlo iterations
    ortho.ErrNy_SinfMin     = mean(ortho.ErrNy_SinfMin,1);
    ortho.ErrA9_SinfMin     = mean(ortho.ErrA9_SinfMin,1);
    ortho.ErrGM_SinfMin     = mean(ortho.ErrGM_SinfMin,1);

    %% Compute SSFT results
    numMonteCarlo = length(ssft.MCresults);
    numDataPoint  = length(ssft.MCresults{1}.info.T);
        
    for ll = 1:numMonteCarlo
        for tt = 1:numDataPoint
            ssft.ErrNy_SinfMin(ll,tt)     = min(ssft.MCresults{ll}.ErrNy_Sinf{tt})     /   ssft.MCresults{ll}.ErrBest_Sinf     -   1; 
            if isempty(ssft.MCresults{ll}.ErrA9_Sinf{tt}), ssft.MCresults{ll}.ErrA9_Sinf{tt} = nan; end
            ssft.ErrA9_SinfMin(ll,tt)     = min(ssft.MCresults{ll}.ErrA9_Sinf{tt})     /   ssft.MCresults{ll}.ErrBest_Sinf     -   1; % minimum over all (k,l) pairs
            if isempty(ssft.MCresults{ll}.ErrGM_Sinf{tt}), ssft.MCresults{ll}.ErrGM_Sinf{tt} = nan; end
            ssft.ErrGM_SinfMin(ll,tt)     = min(ssft.MCresults{ll}.ErrGM_Sinf{tt})     /   ssft.MCresults{ll}.ErrBest_Sinf     -   1; 
        end
    end
    
    % Compute average relative error over all Monte Carlo iterations
    ssft.ErrNy_SinfMin     = mean(ssft.ErrNy_SinfMin,1);
    ssft.ErrA9_SinfMin     = mean(ssft.ErrA9_SinfMin,1);
    ssft.ErrGM_SinfMin     = mean(ssft.ErrGM_SinfMin,1);

    %% Draw the figures now
    hfig{rr} = figure('Position',[100,100,350,320]);
    set(hfig{rr},'name',experimentName{rr},'numbertitle','off')
    h = loglog(ortho.MCresults{1}.info.T, ortho.ErrA9_SinfMin,'-', 'Color',cAlg9);
    hold on
    h = loglog(ssft.MCresults{1}.info.T, ssft.ErrA9_SinfMin,':', 'Color',cAlg92);
    set(get(get(h,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
    h = loglog(ortho.MCresults{1}.info.T, ortho.ErrGM_SinfMin,'-', 'Color',cAlgGM);
    h = loglog(ssft.MCresults{1}.info.T, ssft.ErrGM_SinfMin,':', 'Color',cAlgGM2);
    set(get(get(h,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');
    h = loglog(ortho.MCresults{1}.info.T, ortho.ErrNy_SinfMin,'-', 'Color',cAlgNy);
    h = loglog(ssft.MCresults{1}.info.T, ssft.ErrNy_SinfMin,':', 'Color',cAlgNy2);
    set(get(get(h,'Annotation'),'LegendInformation'),'IconDisplayStyle','off');

    if islegend{rr}
    hleg = legend(...
        '[TYUC17, Alg. 9]', ...
        'Standard (2.6)', ...
        'Proposed (2.7)' ...
        );
    hleg.FontSize = 16;
    hleg.Interpreter = 'latex';
    hleg.Location = 'NorthEast';
    end
    
    ax = gca;
    ax.XTick = xTick{rr};
    set(ax, 'FontSize', 13)
    xlabel('Storage ($T$)','Interpreter','latex','FontSize',17);
    if isylabel{rr}
    ylabel('Relative Error ($S_\infty$)','Interpreter','latex','FontSize',19);
    end
    
    axis tight
    xlim([-inf, inf])
    ylimCur = ylim;
    ylimCur(1) = max(ylimCur(1),1e-9);
    if ylimCur(2)/100 < ylimCur(1)
        ylimCur(1) = 0.9*10^(floor(log10(ylimCur(1))));
    end
    ylim(ylimCur)
    set(gca,'TickDir','out')
    set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
    set(findall(gca, 'Type', 'Line'),'LineWidth',4); 

    if rr == 1
        setPos = ax.Position;
    else
        ax.Position = setPos;
    end
    
end

