%   This script plots the Fig. B.4 in [TYUC2017Nys].
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 25, 2017
%   Last modified: October 24, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% LOAD DATA
clearvars
close all
hfig = {};

experiment = {};
experimentName = {};
isylabel = {};
islegend = {};
xTick    = {};

R = 5;

%% Data
experiment{end+1}       = ['Test_parfor_LowRankPlusNoise_Nystrom/LowNoise_n1000_r10_R',num2str(R),'_complex'];
experimentName{end+1}   = ['LowRankLowNoise_R',num2str(R)];
isylabel{end+1}         = 1;
islegend{end+1}         = 1;
xTick{end+1}            = [12,24,48,96,192];

experiment{end+1}       = ['Test_parfor_LowRankPlusNoise_Nystrom/MedNoise_n1000_r10_R',num2str(R),'_complex'];
experimentName{end+1}   = ['LowRankMedNoise_R',num2str(R)];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_LowRankPlusNoise_Nystrom/HiNoise_n1000_r10_R',num2str(R),'_complex'];
experimentName{end+1}   = ['LowRankHiNoise_R',num2str(R)];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

% Low-Rank + poly decay

experiment{end+1}       = ['Test_parfor_PolyDecay_Nystrom/n1000_r10_R',num2str(R),'_p2_complex'];
experimentName{end+1}   = ['PolyDecayFast_R',num2str(R)];
isylabel{end+1}         = 1;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_PolyDecay_Nystrom/n1000_r10_R',num2str(R),'_p1_complex'];
experimentName{end+1}   = ['PolyDecayMed_R',num2str(R)];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_PolyDecay_Nystrom/n1000_r10_R',num2str(R),'_p0.5_complex'];
experimentName{end+1}   = ['PolyDecaySlow_R',num2str(R)];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

% Low-Rank + exp decay

experiment{end+1}       = ['Test_parfor_ExpDecay_Nystrom/n1000_r10_R',num2str(R),'_q1_complex'];
experimentName{end+1}   = ['ExpDecayFast_R',num2str(R)];
isylabel{end+1}         = 1;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_ExpDecay_Nystrom/n1000_r10_R',num2str(R),'_q0.25_complex'];
experimentName{end+1}   = ['ExpDecayMed_R',num2str(R)];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_ExpDecay_Nystrom/n1000_r10_R',num2str(R),'_q0.1_complex'];
experimentName{end+1}   = ['ExpDecaySlow_R',num2str(R)];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

%% Plot
Plot_Figure_Sch1_Nystrom
