%   This script plots the Fig. B.3 in [TYUC2017Nys].
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 25, 2017
%   Last modified: October 24, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% LOAD DATA
clearvars
close all
hfig = {};

experiment = {};
experimentName = {};
isylabel = {};
islegend = {};
xTick    = {};

%% Real Data
experiment{end+1}       = ['Test_parfor_PhaseRetrieval_Nystrom/r1_complex'];
experimentName{end+1}   = 'PhaseRetrieval_1';
isylabel{end+1}         = 1;
islegend{end+1}         = 0;
xTick{end+1}            = 1*(2.^(0:20));

experiment{end+1}       = ['Test_parfor_PhaseRetrieval_Nystrom/r5_complex'];
experimentName{end+1}   = 'PhaseRetrieval_5';
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = 1*(2.^(0:20));

experiment{end+1}       = ['Test_parfor_MaxCut_Nystrom/G40_r1_real'];
experimentName{end+1}   = 'MaxCut_1';
isylabel{end+1}         = 1;
islegend{end+1}         = 0;
xTick{end+1}            = 1*(2.^(0:20));

experiment{end+1}       = ['Test_parfor_MaxCut_Nystrom/G40_r14_real'];
experimentName{end+1}   = 'MaxCut_14';
isylabel{end+1}         = 0;
islegend{end+1}         = 1;
xTick{end+1}            = 1*(2.^(0:20));

%% Plot
Plot_Figure_SchInf_Nystrom