%   This script plots the Fig. B.1 in [TYUC2017Nys].
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: May 12, 2017
%   Last modified: October 24, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% LOAD DATA
clearvars
close all

hfig = {};
name = {};

%%
load data/Nystrom_LowRankLowNoise_n1000_R10
singVal_LowNoise = singVals
load data/Nystrom_LowRankMedNoise_n1000_R10
singVal_MedNoise = singVals;
load data/Nystrom_LowRankHiNoise_n1000_R10
singVal_HighNoise = singVals;

name{end+1} = 'LowRankPlusNoise';
hfig{end+1} = figure('Position',[100,100,350,320]);
set(hfig{end},'name',name{end},'numbertitle','off');
loglog(singVal_HighNoise,'-');
hold on
loglog(singVal_MedNoise,'--');
loglog(singVal_LowNoise,'-.');

set(gca,'TickDir','out')
set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
set(findall(gca, 'Type', 'Line'),'LineWidth',2); 

ylim([.7e-5,2])

ax = gca;
ax.YTick = 10.^[-10:10];

hleg = legend('HiNoise', 'MedNoise', 'LowNoise');
hleg.FontSize = 16;
hleg.Interpreter = 'latex';
hleg.Location = 'SouthWest';

set(ax, 'FontSize', 13)
xlabel('$j$','Interpreter','latex','FontSize',17);
ylabel('$j^{th}$ singular value','Interpreter','latex','FontSize',19);

ax1 = gca;

%%
name{end+1} = 'PolyDecayingSpectrum';
hfig{end+1} = figure('Position',[100,100,350,320]);
set(hfig{end},'name',name{end},'numbertitle','off');
R = 10;
n = 1e3;

Sigma(1:R) = 1;
Sigma((R+1):n) = (((1:(n-R))+1).^(-0.5));
singVals_PSLOW = Sigma;
clearvars Sigma

Sigma(1:R) = 1;
Sigma((R+1):n) = (((1:(n-R))+1).^(-1));
singVals_PMED = Sigma;
clearvars Sigma

Sigma(1:R) = 1;
Sigma((R+1):n) = (((1:(n-R))+1).^(-2));
singVals_PFAST = Sigma;
clearvars Sigma

loglog(singVals_PSLOW,'-');
hold on
loglog(singVals_PMED,'--');
loglog(singVals_PFAST,'-.');

set(gca,'TickDir','out')
set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
set(findall(gca, 'Type', 'Line'),'LineWidth',2); 

hleg = legend('PolySlow', 'PolyMed', 'PolyFast');
hleg.FontSize = 16;
hleg.Interpreter = 'latex';
hleg.Location = 'SouthWest';
ylim([.7e-6,2])

ax = gca;
ax.YTick = 10.^[-10:1:10];

set(ax, 'FontSize', 13)
xlabel('$j$','Interpreter','latex','FontSize',17);

ax.Position = ax1.Position;

%%
name{end+1} = 'ExpDecayingSpectrum';
hfig{end+1} = figure('Position',[100,100,350,320]);
set(hfig{end},'name',name{end},'numbertitle','off');
R = 10;
n = 1e3;

Sigma(1:R) = 1;
Sigma((R+1):n) = (((1:(n-R))+1).^(-1));
singVals_PSLOW = Sigma;
clearvars Sigma

Sigma(1:R) = 1;
Sigma((R+1):n) = (((1:(n-R))+1).^(-2));
singVals_PFAST = Sigma;
clearvars Sigma

Sigma(1:R) = 1;
Sigma((R+1):n) = 10.^(-0.1*((1:(n-R))+1));
singVals_ESLOW = Sigma;
clearvars Sigma

Sigma(1:R) = 1;
Sigma((R+1):n) = 10.^(-0.25*((1:(n-R))+1));
singVals_EMED = Sigma;
clearvars Sigma

Sigma(1:R) = 1;
Sigma((R+1):n) = 10.^(-1*((1:(n-R))+1));
singVals_EFAST = Sigma;
clearvars Sigma

loglog(singVals_ESLOW,'-');
hold on
loglog(singVals_EMED,'--');
loglog(singVals_EFAST,'-.');

set(gca,'TickDir','out')
set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
set(findall(gca, 'Type', 'Line'),'LineWidth',2); 

hleg = legend('ExpSlow', 'ExpMed', 'ExpFast');
hleg.FontSize = 16;
hleg.Interpreter = 'latex';
hleg.Location = 'NorthEast';
ylim([.7e-9,2])
xlim([1,1e3])
ax = gca;
ax.YTick = 10.^[-10:1:10];

set(ax, 'FontSize', 13)
xlabel('$j$','Interpreter','latex','FontSize',17);

ax.Position = ax1.Position;


%%
name{end+1} = 'RealData';
load data/FourrierPtychographySingVals
singVals_PR = diag(info.Z);
singVals_PR = singVals_PR./max(singVals_PR);

load data/Nystrom_MaxCut_G40
singVals_MC = singVals;
singVals_MC = singVals_MC./max(singVals_MC);

hfig{end+1} = figure('Position',[100,100,350,320]);
set(hfig{end},'name',name{end},'numbertitle','off');
loglog(singVals_MC,'-');
hold on
loglog(singVals_PR,'--');

set(gca,'TickDir','out')
set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
set(findall(gca, 'Type', 'Line'),'LineWidth',2); 

hleg = legend('MaxCut','PhaseRetrieval');
hleg.FontSize = 16;
hleg.Interpreter = 'latex';
hleg.Location = 'SouthWest';

ax = gca;
ax.YTick = 10.^[-30:3:30];
xlim([1,2.0001e3])
set(ax, 'FontSize', 13)
xlabel('$j$','Interpreter','latex','FontSize',17);

ax.Position = ax1.Position;

