%   This script plots the Fig. B.11 in [TYUC2017Nys].
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 25, 2017
%   Last modified: October 24, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% LOAD DATA
clearvars
close all
hfig = {};

experiment = {};
experimentName = {};
isylabel = {};
islegend = {};
xTick    = {};

%% Low-Rank + exp decay
experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R20_q1_complex'];
experimentName{end+1}   = ['Stability_ExpDecayFast_R20'];
isylabel{end+1}         = 1;
islegend{end+1}         = 0;
xTick{end+1}            = 10*2.^(0:10);

experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R20_q0.25_complex'];
experimentName{end+1}   = ['Stability_ExpDecayMed_R20'];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R20_q0.1_complex'];
experimentName{end+1}   = ['Stability_ExpDecaySlow_R20'];
isylabel{end+1}         = 0;
islegend{end+1}         = 1;
xTick{end+1}            = xTick{end};

%%
experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R5_q1_complex'];
experimentName{end+1}   = ['Stability_ExpDecayFast_R5'];
isylabel{end+1}         = 1;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};


experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R5_q0.25_complex'];
experimentName{end+1}   = ['Stability_ExpDecayMed_R5'];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R5_q0.1_complex'];
experimentName{end+1}   = ['Stability_ExpDecaySlow_R5'];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};



%%
experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R10_q1_complex'];
experimentName{end+1}   = ['Stability_ExpDecayFast_R10'];
isylabel{end+1}         = 1;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R10_q0.25_complex'];
experimentName{end+1}   = ['Stability_ExpDecayMed_R10'];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};

experiment{end+1}       = ['Test_parfor_StableImplementation_Nystrom/n1000_r10_R10_q0.1_complex'];
experimentName{end+1}   = ['Stability_ExpDecaySlow_R10'];
isylabel{end+1}         = 0;
islegend{end+1}         = 0;
xTick{end+1}            = xTick{end};



%% Colors and more
cAlgNy   = [.6,.6,.6];
cAlgNy2   = [0,0,0];

cAlg9    = [.95,.5,.35];
cAlg92    = [.7,.2,0];

cAlgGM   = [.6,.85,1];
cAlgGM2   = [.2,.7,.9];

%% First test: Test_parfor_IdentityMatrix
for rr = 1:length(experiment)
    clearvars Err*
    dname_ortho = dir(['results/NystromSketch/',experiment{rr},'_orthonormal/*.mat']);
    data_ortho = load(['results/NystromSketch/',experiment{rr},'_orthonormal/',dname_ortho.name]);
    dname_ssft = dir(['results/NystromSketch/',experiment{rr},'_ssft/*.mat']);
    data_ssft = load(['results/NystromSketch/',experiment{rr},'_ssft/',dname_ssft.name]);

    numMonteCarlo = length(data_ortho.MCresults);
    numDataPoint  = length(data_ortho.MCresults{1}.info.T);
    
    T = data_ortho.MCresults{1}.info.T;
    r  = data_ortho.MCresults{1}.info.r;
    
    for ll = 1:numMonteCarlo
        for tt = 1:numDataPoint
            data_ortho.ErrSta_S1Min(ll,tt)     = data_ortho.MCresults{ll}.ErrSta_S1{tt}     /   data_ortho.MCresults{ll}.ErrBest_S1     -   1; 
            data_ortho.ErrUns_S1Min(ll,tt)     = data_ortho.MCresults{ll}.ErrUns_S1{tt}     /   data_ortho.MCresults{ll}.ErrBest_S1     -   1; 
            data_ssft.ErrSta_S1Min(ll,tt)     = data_ssft.MCresults{ll}.ErrSta_S1{tt}     /   data_ssft.MCresults{ll}.ErrBest_S1     -   1; 
            data_ssft.ErrUns_S1Min(ll,tt)     = data_ssft.MCresults{ll}.ErrUns_S1{tt}     /   data_ssft.MCresults{ll}.ErrBest_S1     -   1; 
        end
    end
    
    % Compute average relative error over all Monte Carlo iterations
    data_ortho.ErrSta_S1Min     = mean(data_ortho.ErrSta_S1Min,1);
    data_ortho.ErrUns_S1Min     = mean(data_ortho.ErrUns_S1Min,1);
    data_ssft.ErrSta_S1Min     = mean(data_ssft.ErrSta_S1Min,1);
    data_ssft.ErrUns_S1Min     = mean(data_ssft.ErrUns_S1Min,1);

    hfig{rr} = figure('Position',[100,100,350,320]);
    set(hfig{rr},'name',experimentName{rr},'numbertitle','off')
    h = loglog(data_ortho.MCresults{1}.info.T, data_ortho.ErrUns_S1Min,'-', 'Color',cAlg9);
    hold on
    h = loglog(data_ortho.MCresults{1}.info.T, data_ortho.ErrSta_S1Min,'-', 'Color',cAlgNy);
    h = loglog(data_ssft.MCresults{1}.info.T, data_ssft.ErrUns_S1Min,'--', 'Color',cAlg92);
    hold on
    h = loglog(data_ssft.MCresults{1}.info.T, data_ssft.ErrSta_S1Min,'--', 'Color',cAlgNy2);

    if islegend{rr}
    hleg = legend(...
        '[LLS+17]', ...
        'Algorithm 3' ...
        );
    hleg.FontSize = 16;
    hleg.Interpreter = 'latex';
    hleg.Location = 'NorthEast';
    end
    
    ax = gca;
    ax.XTick = xTick{rr};
    ax.YTick = 10.^(-20:2:10);
    set(ax, 'FontSize', 13)
    xlabel('Storage ($T$)','Interpreter','latex','FontSize',17);
    if isylabel{rr}
    ylabel('Relative Error ($S_1$)','Interpreter','latex','FontSize',19);
    end
    
    axis tight
    xlim([-inf, 320])
    ylimCur = ylim;
    ylim(ylimCur);
    set(gca,'TickDir','out')
    set(gca,'LineWidth',1,'TickLength',[0.02 0.02]);
    set(findall(gca, 'Type', 'Line'),'LineWidth',4); 

    if rr == 1
        setPos = ax.Position;
    else
        ax.Position = setPos;
    end
    
end
