%This script batches the experimental instances into the cluster.
%Experiments are carried out in parallel. 
%
%   See our reference paper for the detailed explanation of the
%   sketching procedure and the arithmetic, communication and storage
%   costs.
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 12, 2017
%   Last modified: October 23, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys???SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% Beginning of the test

n = 1000;
r = 10;
field = 'complex';
MonteCarloNum = 20;

c = parcluster;

ClusterInfo.setMemUsage('3gb');

experiment          = {};

%% For R = 5
% Low-Rank + noise
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,5,'HiNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,5,'MedNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,5,'LowNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,5,'HiNoise',field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,5,'MedNoise',field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,5,'LowNoise',field,'ssft',MonteCarloNum);
% Low-Rank + poly decay
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,5,0.5,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,5,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,5,2,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,5,0.5,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,5,1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,5,2,field,'ssft',MonteCarloNum);
% Low-Rank + exp decay
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,5,0.1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,5,0.25,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,5,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,5,0.1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,5,0.25,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,5,1,field,'ssft',MonteCarloNum);
 
%% For R = 10
% Low-Rank + noise
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,10,'HiNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,10,'MedNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,10,'LowNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,10,'HiNoise',field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,10,'MedNoise',field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,10,'LowNoise',field,'ssft',MonteCarloNum);
% Low-Rank + poly decay
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,10,0.5,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,10,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,10,2,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,10,0.5,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,10,1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,10,2,field,'ssft',MonteCarloNum);
% Low-Rank + exp decay
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,10,0.1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,10,0.25,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,10,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,10,0.1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,10,0.25,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,10,1,field,'ssft',MonteCarloNum);

%% For R = 20
% Low-Rank + noise
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,20,'HiNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,20,'MedNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,20,'LowNoise',field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,20,'HiNoise',field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,20,'MedNoise',field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_LowRankPlusNoise_Nystrom(n,r,20,'LowNoise',field,'ssft',MonteCarloNum);
% Low-Rank + poly decay
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,20,0.5,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,20,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,20,2,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,20,0.5,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,20,1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PolyDecay_Nystrom(n,r,20,2,field,'ssft',MonteCarloNum);
% Low-Rank + exp decay
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,20,0.1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,20,0.25,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,20,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,20,0.1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,20,0.25,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_ExpDecay_Nystrom(n,r,20,1,field,'ssft',MonteCarloNum);

%% Real Data R = 1
experiment{end+1}   = @() Test_parfor_PhaseRetrieval_Nystrom(1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PhaseRetrieval_Nystrom(1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_MaxCut_Nystrom('G40',1,'real','orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_MaxCut_Nystrom('G40',1,'real','ssft',MonteCarloNum);

%% Real Data R = r
experiment{end+1}   = @() Test_parfor_PhaseRetrieval_Nystrom(5,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_PhaseRetrieval_Nystrom(5,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_MaxCut_Nystrom('G40',14,'real','orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_MaxCut_Nystrom('G40',14,'real','ssft',MonteCarloNum);

%% Test for stable implementation
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,10,1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,5,1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,20,1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,10,0.25,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,5,0.25,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,20,0.25,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,10,0.1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,5,0.1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,20,0.1,field,'ssft',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,10,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,5,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,20,1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,10,0.25,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,5,0.25,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,20,0.25,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,10,0.1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,5,0.1,field,'orthonormal',MonteCarloNum);
experiment{end+1}   = @() Test_parfor_StableImplementation_Nystrom(n,r,20,0.1,field,'orthonormal',MonteCarloNum);

%% 
j = {};
for tt = 1:length(experiment)
    fprintf('Batching experiment No:%d...',tt);
    c.batch(experiment{tt},1,{},'pool',MonteCarloNum+1,...
        'AttachedFiles', {'ifft','fft'},...
        'CurrentFolder','/home/yurtseve/Codes/NYSTROMSKETCH'); 	% You need to Set this folder as your working directory on your cluster
    fprintf(' Started..\n');
end
