%In Section 5 of [TYUC2017Nys], we also consider application examples. We 
%consider non-diagonal matrices inspired by the SDP algorithm [YUTC2017].
%This script creates the data for the phase retrieval instance: This is a 
%psd matrix with dimension n = 25 921. It has exact rank 250, but its 
%effective rank R = 5. The matrix is an approximate solution to a phase 
%retrieval SDP.
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   [YUTC2017] A. Yurtsever, M. Udell, J.A. Tropp and V. Cevher. Sketchy 
%   Decisions: Convex Low-Rank Matrix Optimization with Optimal Storage. 
%   In Proc. 20th Int. Conf. Artificial Intelligence and Statistics 
%   (AISTATS), Fort Lauderdale, May 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: August 24, 2016
%   Last modified: October 24, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% Fix the seed
clearvars
rng(0,'twister');

%% Test setup
load data/FourrierPtychographySingVals
info.U = randn(info.m, size(info.Z,1)) + 1i*randn(info.m, size(info.Z,1));
info.U = orth(info.U);
save data/FourrierPtychographyData