%In Section 5 of [TYUC2017Nys], we consider some numerical experiments. This 
%script draws a random input matrix instances for Low-Rank + PSD Noise
%model. 
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 12, 2017
%   Last modified: October 24, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% Fix the seed
rng(0,'twister');

%% Test setup
clearvars


ksi = [1e-4, 1e-2, 1e-1];
sname = {'LowNoise','MedNoise','HiNoise'};

n = 1000;

Rsweep = [5,10,20];

for R = Rsweep
    for t = 1:length(ksi)
        
        % Generate the matrix A
        A = zeros(n,n);
        A(1:R,1:R) = diag(ones(R,1));
        G = (randn(n,n) + 1i*randn(n,n));
        W = G*G';
        clearvars G;
        A = A + ksi(t)/n.*W;
        clearvars W;
        
        %% Find the ground truth (best rank-r approximation)
        [~, Sigmar, ~] = svd(A);
        
        singVals = diag(Sigmar);
        clearvars Sigmar;

        %% Save data
        dataname = ['data/Nystrom_LowRank',sname{t},'_n',num2str(n),'_R',num2str(R),'.mat'];
        save(dataname)
        
    end
end