%In Section 5 of [TYUC2017Nys], we also consider application examples. 
%This script creates the data for the Max-Cut instance: This is a 
%real-valued psd matrix with dimension n = 2000, and its effective rank
%R = 14. The matrix is an approximate solution to the MAXCUT SDP for the 
%sparse graph G40.
%
%   [TYUC2017Nys] J.A. Tropp, A. Yurtsever, M. Udell and V. Cevher. Fixed-
%   Rank Approximation of a Positive-Semidefinite Matrix from Streaming 
%   Data. In Proc. 31st Conference on Neural Information Processing Systems
%   (NIPS), Long Beach, CA, USA, December 2017.
%
%   Coded by: Alp Yurtsever
%   Ecole Polytechnique Federale de Lausanne, Switzerland.
%   Laboratory for Information and Inference Systems, LIONS.
%   contact: alp.yurtsever@epfl.ch
%   Created: April 19, 2017
%   Last modified: October 24, 2017
%
%Nys-SKETCHv1.0
%Copyright (C) 2017 Laboratory for Information and Inference Systems
%(LIONS), Ecole Polytechnique Federale de Lausanne, Switzerland.
%This code is a part of Nys-SKETCH toolbox. 
%Please read COPYRIGHT before using this file.

%% Fix the seed
clearvars
rng(0,'twister');

%% Test setup

if ~exist('cvx_begin','file')
    error('This test requires <a href="http://cvxr.com/cvx">CVX</a>.');
end
dataname = 'G40';
if ~exist(['data/',dataname,'.mat'],'file')
    error('Please install G40 dataset from <a href="https://www.cise.ufl.edu/research/sparse/matrices/Gset/G40.html">this link</a> and copy under data folder.');
end

load(['data/',dataname,'.mat']);
n = size(Problem.A,1);
L = sparse(diag(Problem.A*ones(n,1)) - Problem.A);
clearvars Problem; 

cvx_begin sdp
    variable A(n,n) symmetric
    minimize -0.25*trace(A'*L)
    diag(A) == ones(n,1)
    A == semidefinite( n )
cvx_end
clearvars L

[~, singVals, ~] = svd(A);
singVals = diag(singVals);

save(['data/Nystrom_MaxCut_',dataname]);
