% TEST OUR SOLVER FOR THE CONSTRAINED L1/L2 PROBLEM OF THE FORM:
%
%                   min |W.*x|_1 s.t. |A*x - b|_2 <= delta.
%
% Date: 31.12.2013
% Implemented by Quoc Tran-Dinh, LIONS, EPFL, Switzerland

%% Problem size.
scale   = 1;
n       = round(scale*1000);
m       = round(scale*400); 
k       = round(scale*100); 

% Print the problem size.
fprintf('+ The problem size [m, n, k] = [%d, %d, %d] ...\n', m, n, k);

%% Generate the input data.
%rand('twister',0); randn('state',0);

% Noise level.
sigma   = 0.01;

% Generate matrix A & x.
cor_tau = 0.5;
if cor_tau > 0
    var0 = (1 - cor_tau)^2 / (1 - cor_tau^2); %initial variance
    A = zeros(m, n);
    A(:,1) = sqrt(var0)*randn(m, 1);
    for kk = 2:n
        A(:,kk) = cor_tau*A(:,kk-1) + (1 - cor_tau)*(randn(m,1));
    end
else
    A = randn(m, n);
end

% Generate vector x_org.
x_org    = zeros(n, 1);
T        = randsample(n, k);
x_org(T) = randn(k, 1);

% Generate vector b.
b  = A*x_org + sigma*randn(m, 1);

% Generate an initial point.
x0 = 0.*ones(n, 1);

% Generate the noise level parameter.
delta    = 0.9*norm(A*x_org - b, 2);

% Weighted vector for the l1-norm.
weights  = ones(n, 1);

%% Test the unconstrained L1/L1 problem without weighted and no operators.
tolx = 1e-6;

% Set the parameters.
param.MaxIters      = 3000;
param.Verbosity     = 2;
param.RelTolX       = tolx;
param.saveHistMode  = 0;
param.Algorithm     = 1;
param.InnerMaxIters = 5;
param.adaptStepSize = 0;

% Call the solver.
[x1, out1] = decoptSolver('L1/L2con', A, b, param, ...
                          'NoiseLevel', delta, 'x0', x0);

% Evaluate the objective values and feasibility gap.
fx1   = norm(weights.*x1, 1);
feas1 = max( norm(A*x1 - b, 2) - delta, 0);

%% Printing ...
fprintf('******************** THE FINAL RESULTS ************************\n');
fprintf('+ DECOM: L1L2con - problem: f(x) = %3.7f, feas = %3.7f\n', fx1, feas3);
fprintf('+ DECOM: Iterations: %4d, Time(s) = %3.4f\n', out1.iter, out1.total_time);
fprintf('+ DECOM: Number of Ax and ATy are %4d and %4d\n', out1.cntA, out1.cntAt);
fprintf('+ DECOM: Reconvery error: %4.7f\n', norm(x1 - x_org)/max(norm(x_org), 1));

%% END OF THE TEST.