% TEST OUR SOLVER FOR THE UNCONSTRAINED L1/L1 PROBLEM OF THE FORM:
%       
%                   min_x |A*x - b|_1 + |w.*x|_1
%
% Date: 31.12.2013
% Implemented by Quoc Tran-Dinh, LIONS, EPFL, Switzerland

%% Plot or not ...
isPlotFigure = 1;

%% Problem size.
scale   = 1;
n       = scale*1000;
m       = scale*500; 
k       = scale*100; 

% Print the problem size.
fprintf('+ The problem size [m, n, k] = [%d, %d, %d] ...\n', m, n, k);

%% Generate the input data.
%rand('twister',0); 
%randn('state',0);

% Noise level.
sigma   = 1.0e-2;

% Generate matrix A.
cor_tau = 0.0;
if cor_tau > 0
    var0 = (1 - cor_tau)^2 / (1 - cor_tau^2); %initial variance
    A = zeros(m, n);
    A(:,1) = sqrt(var0)*randn(m, 1);
    for kk = 2:n
        A(:,kk) = cor_tau*A(:,kk-1) + (1 - cor_tau)*(randn(m,1));
    end
else
    A       = randn(m, n);
end

% Generate vector b.
x_org    = zeros(n, 1);
T        = randsample(n, k);
x_org(T) = randn(k, 1);
noise    = thresh( randn(m, 1), 100);
b        = A*x_org + 2*sigma* noise;

% Generate an initial point.
x0       = zeros(n, 1);

% Generate the regularization parameter.
rho      = 0.5;

%% Test the unconstrained L1/L1 problem without weighted and no operators.
% Set the parameters.
param.MaxIters      = 5000;
param.Verbosity     = 2;   
param.RelTolX       = 1e-6;
param.saveHistMode  = 0;
param.Algorithm     = 3;
param.InnerMaxIters = 2;
param.adaptStepSize = 0;


% Call the solver.
[x1, out1] = decoptSolver('L1/L1', A, b, param, 'RegPar', rho, 'x0', x0);
    
% Evaluate the objective values and feasibility gap.
fx1 = norm(A*x1 - b, 1) + norm(rho.*x1, 1);

%% Printing ...
fprintf('******************** THE FINAL RESULTS ************************\n');
fprintf('+ DECOM: L1L1 - problem: f(x) = %3.7f\n', fx1);
fprintf('+ DECOM: Iterations: %4d, Time(s) = %3.4f\n', out1.iter, out1.total_time);
fprintf('+ DECOM: Number of Ax and ATy are %4d and %4d\n', out1.cntA, out1.cntAt);
fprintf('+ DECOM: Reconvery error: %4.7f\n', norm(x1 - x_org)/max(norm(x_org), 1));

%% Plot the figures.
if isPlotFigure 
    % Plot the solution.
    figure(1); title('The solutions');
    if isreal(x_org), stairs(x_org, 'g:*');  else stairs(abs(x_org), 'g:*'); end
    hold on;
    if isreal(x1), stairs(x1, 'r--o');  else stairs(abs(x1), 'r--o'); end
    legend('Original signal', 'Decomp-solution');
    hold off;
    shg;
end

%% END OF THE TEST.