% TEST OUR SOLVER FOR THE BASIS PURSUIT PROBLEM OF THE FORM:
%
%               min |w.*x|_1  s.t. A*x = b.
%
% Date: 31.12.2013

%% Problem size.
scale   = 5;
n       = scale*1024;
m       = scale*341; 
ng      = round(m/4);
K       = round(ng/8);

% Print the problem size.
fprintf('+ The problem size [m, n, k] = [%d, %d, %d] ...\n', m, n, K);

%% Generate the input data.
%rand( 'twister', 0); randn('state',   0);

% Generate the the group.
gindices = [];
while (length(unique(gindices)) ~= ng)
    gindices  = ceil(rand(n,1) * ng);
end
groups.ng = ng;
groups.indices = gindices;
mgroups = sparse(ng, n);
for i=1:ng
    mgroups(i, gindices == i) = 1;
end

% Generate the weight of the groups.
weights = rand(ng, 1) + 1;

% Noise level.
sigma      = 0*1e-3;

% Create K-group-sparse vector x0 and observation vector b
p          = randperm(ng); 
p          = p(1:K);
idx        = ismember(gindices, p);
nNz        = sum(idx);  % number of nonzeros
x_org      = zeros(n, 1); 
x_org(idx) = randn(sum(idx), 1);


% Generate matrix A & x.
cor_tau = 0.0;
if cor_tau > 0
    var0 = (1 - cor_tau)^2 / (1 - cor_tau^2); %initial variance
    A = zeros(m, n);
    A(:,1) = sqrt(var0)*randn(m, 1);
    for kk = 2:n
        A(:,kk) = cor_tau*A(:,kk-1) + (1 - cor_tau)*(randn(m,1));
    end
else
    A    = randn(m, n);
end

% Generate vector b.
b        = A*x_org + sigma*randn(m, 1);

% Generate an initial point.
x0       = 0.*ones(n, 1);

%% Test the BP problem.
tolx     = 1e-6;
maxiters = 1000;

% Set the parameters.
param.MaxIters      = maxiters;
param.Verbosity     = 2;
param.RelTolX       = tolx;
param.RelTolFeas    = tolx;
param.saveHistMode  = 4;
param.Algorithm     = 1; % Choose 1 or 3.
param.InnerMaxIters = 3; % Set to 5 --> 10.
param.InnerRelTol   = tolx;
param.adaptStepSize = 0;

% Call the solver.
[x1, out1] = decoptSolver('GBP', A, b, param, 'x0', x0, ...
                          'groups', groups, 'RegPar', weights);

% Evaluate the objective values and feasibility gap.
fx1   = sum(weights.*sqrt(mgroups*x1.^2));
feas1 = norm(A*x1 - b, 2); 

%% Printing ...
fprintf('******************** THE FINAL RESULTS ************************\n');
fprintf('+ DECOM: BP-problem: [f(x), |A*x-b|/|b|] = [%3.12f, %5.12f]\n', fx1, feas1/norm(b));
fprintf('+ DECOM: Iterations: %4d, Time(s) = %3.4f\n', out1.iter, out1.total_time);
fprintf('+ DECOM: Number of Ax and ATy are %4d and %4d\n', out1.cntA, out1.cntAt);
fprintf('+ DECOM: Reconvery error: %4.7f\n', norm(x1 - x_org)/max(norm(x_org), 1));

%% END OF THE TEST.