% TEST OUR SOLVER FOR THE BASIS PURSUIT PROBLEM OF THE FORM:
%
%               min |w.*x|_1  s.t. A*x = b.
%
% Date: 31.12.2013

%% Plot or not ...
isPlotFigure  = 1;

%% Problem size.
scale   = 2;
n       = scale*1000;
m       = scale*350; 
k       = scale*100; 

% Print the problem size.
fprintf('+ The problem size [m, n, k] = [%d, %d, %d] ...\n', m, n, k);

%% Generate the input data.
%rand( 'twister', 0); randn('state',   0);

% Noise level.
sigma    = 1.0e-2;     % why are we using noise here? 
x_org    = zeros(n, 1);
T        = randsample(n, k);
x_org(T) = randn(k, 1);

% Generate matrix A & x.
cor_tau = 0.0;
if cor_tau > 0
    var0 = (1 - cor_tau)^2 / (1 - cor_tau^2); %initial variance
    A = zeros(m, n);
    A(:,1) = sqrt(var0)*randn(m, 1);
    for kk = 2:n
        A(:,kk) = cor_tau*A(:,kk-1) + (1 - cor_tau)*(randn(m,1));
    end
else
    A       = randn(m, n);
end

% Generate vector b.
b        = A*x_org + sigma*randn(m, 1);

% Generate an initial point.
x0       = 0.*ones(n, 1);

%% Test the BP problem.
tolx = 1e-6;

% Set the parameters.
param.MaxIters      = 3000;
param.Verbosity     = 2;
param.RelTolX       = tolx;
param.saveHistMode  = 1;
param.Algorithm     = 1;  % You should choose 1 or 3 ...
param.InnerMaxIters = 2;  % This option can be set to 5 -> 10 ...
param.adaptStepSize = 0;  

% Call the solver - By default ...
if 1
    [x1, out1] = decoptSolver('BP', A, b, param, 'x0', x0);
else
    % User-define proximal-functions.
    proxOpers{1} = @(x, gamma, varargin)(proxL1norm(x, gamma));
    proxOpers{2} = @(x, gamma, varargin)(projL2norm(x, 1e-12));

    proxOpers{3} = @(x, varargin)(norm(x(:), 1));
    proxOpers{4} = @(x, varargin)(0);

    % Call the solver with user-define prox-functions.
    [x1, out1] = decoptSolver('UserDef', A, b, param, 'x0', x0, 'Prox', proxOpers);
end

% Evaluate the objective values and feasibility gap.
fx1   = norm(x1, 1);
feas1 = norm(A*x1 - b, 2); 

%% Printing ...
fprintf('******************** THE FINAL RESULTS ************************\n');
fprintf('+ DECOM: BP-problem: [f(x), |A*x-b|/|b|] = [%3.7f, %5.7f]\n', fx1, feas1/norm(b));
fprintf('+ DECOM: Iterations: %4d, Time(s) = %3.4f\n', out1.iter, out1.total_time);
fprintf('+ DECOM: Number of Ax and ATy are %4d and %4d\n', out1.cntA, out1.cntAt);
fprintf('+ DECOM: Reconvery error: %4.7f\n', norm(x1 - x_org)/max(norm(x_org), 1));


%% Plot the figures.
if isPlotFigure 
    
    % Plot the solution.
    figure(1); title('The solutions');
    if isreal(x_org), stairs(x_org, 'g:*');  else stairs(abs(x_org), 'g:*'); end
    hold on;
    if isreal(x1), stairs(x1, 'r--o');  else stairs(abs(x1), 'r--o'); end
    hold off;
    shg;
end

%% END OF THE TEST.