clc;
clear;
addpath operators/
addpath algorithms/
addpath algorithms/misc/

%% Load an image & Choose number of measurements
im = im2double(imread('cameraman.tif'));
N = size(im, 1); nb_meas = round(.25*N^2);

%% Measurements - Spread spectrum technique 
% (Puy et al., EURASIP J. Adv. Sig. Processing, vol. 2012(6), 2012)
% Measurement operators
C = rand(N, N); C(C<=.5) = -1; C(C>.5) = +1; % Modulation
I = randperm(N^2); M = zeros(N, N); M(I(1:nb_meas)) = 1; % Mask
A = @(x) opMeas(x, C, M);
At = @(x) optMeas(x, C, M, [N N]);
% Measurements
y = A(im);

%% Sparsity operators - Sparco toolbox needed
W = opWavelet(N, N, 'daubechies', 4, log2(N), 'min');
Psi = @(x) reshape(W(x(:), 1), N, N);
Psit = @(x) reshape(W(x(:), 2), N, N);

%% Reconstructions
K = numel(y); % Choose sparsity level
lambda = .8*TV_norm(im); % List of TV norm
sol_CLASH_TV = CLASH_TV(y, A, At, Psi, Psit, lambda, K, 25, 1e-4, ...
    'regular', im);
disp(SNR(im, real(sol_CLASH_TV)));