function [htmlStr] = createHelpText(help)
%Generate the texts from the help menus of the SOFItutorial_demoMenu
%
%Inputs:
% help      number specifying which text to generate since it is different
%           for each help menus
%
%Outputs:
% htmlStr   HTML string containing the text for the help menu defined by
%           the input number 'help'

% Copyright  2015 Arik Girsault 
% cole Polytechnique Fdrale de Lausanne,
% Laboratoire d'Optique Biomdicale, BM 5.142, Station 17, 1015 Lausanne, Switzerland.
% arik.girsault@epfl.ch, tomas.lukes@epfl.ch
% http://lob.epfl.ch/
 
% This file is part of SOFIsim.
%
% SOFIsim is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% SOFIsim is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with SOFIsim.  If not, see <http://www.gnu.org/licenses/>.
% 
% font: 
%       <font size="N"> text </font> 
%       <font face="cambria" color="black"> text </font>
%       <div align="justified"> text </div> 
%
% greek letters: '&greek_letter_name'
%
% bold: <b> text </b>
% italic: <i> text </i>
% subscript: <sub> text </sub>
% superscript: <sup> text </sup> 
% line break: <br>, double line break: <br><br>

% set(h,'String',str);

switch help
    case 1
        htmlStr = ['<div align="justified"><font face="cambria" color="black"><font size = "4">The sample is composed of M stochastically independently fluctuating emitters. The intensity distribution over time per pixel <b>r</b> can be written as','<br><br>',...
                   '<i>Equation (1)</i>','<br><br>',...
                   'where <i>&epsilon;<sub>k</sub></i>, <i><b>r</b><sub>k</sub></i> and <i>s<sub>k</sub>(t)</i> denote the brightness, position and normalized temporal&nbsp;',...
                   'fluctuations of the k<sup>th</sup>-emitter. <i>U(<b>r</b>)</i> is the systems point-spread function (PSF) and b represents a temporally constant background. Supposing an infinite resolution and zero noise contribution, we can write','<br><br>',...
                   '<i>Equation (2)</i>','<br><br>',...
                   'which represents the object. Ultimately, we would like to design an imaging system S such that in an ideal case, we would image perfectly the object:','<br><br>',...
                   '<i>Equation (3)</i>','<br><br>',...                   
                   'To approach this perfect imaging, we will take N images for achieving a super-resolved image. In fact, we exploit the temporal fluctuations registered as a sequence of individual&nbsp;',...
                   'images. <i>I(<b>r</b>,t)</i> can be split in a spatial component <i>&epsilon;<sub>k</sub>U(<b>r</b>-<b>r</b><sub>k</sub>)</i> and a temporal fluctuating component <i>s<sub>k</sub>(t)</i>, the time&nbsp;',...
                   'traces of the k<sup>th</sup>-emitter. Ideal imaging fully exploits <i>s<sub>k</sub>(t)</i> to generate a super-resolved image.','<br><br>',...                               
                   'Using time  or more specifically, the temporal fluctuations of emitters  as a way to achieve super-resolution can be performed by employing higher-order statistics:,'...
                   'the photon traces per pixel are analysed based on moments or cumulants. The 1<sup>st</sup> and 2<sup>nd</sup> order moments are widely used in engineering and are known as the mean and variance of a stochastic process.','<br><br>',...  
                   'The 4<sup>th</sup> order moment <i>(n &ge 4)</i> and all higher order moments of two statistically independent stochastic processes does not equal the sum of the moments of the individual processes meaning moments are not additive:','<br><br>',...
                   '<i>&mu;<sub>n</sub>(I(<b>r</b><sub>1</sub>,t)+I(<b>r</b><sub>2</sub>,t)) &ne; &mu;<sub>n</sub>(I(<b>r</b><sub>1</sub>,t)) + &mu;<sub>n</sub>(I(<b>r</b><sub>2</sub>,t))</i>','<br><br>',... %'<i>Equation (4)</i>','<br><br>',...
                   'In other words, the <i>n<sup>th</sup></i> order moment of <i>I(<b>r</b>,t)</i> would result mainly from cross-talks between the two fluorophores. This principle can be further extended resulting in&nbsp;',...
                   'many more cross-talks as the number of fluorophore in <i>I(<b>r</b>,t)</i> is increasing.','<br><br>',...
                   'An elegant way to resolve this issue is to use cumulants rather than moments. A rigorous analytical description of cumulants is beyond the scope of this tutorial and we will thus only&nbsp;',...
                   'list a few of its key properties and explain how they enable to provide noise and background free superresolution images.','<br><br>',...
                   'Defintion: The <i>n<sup>th</sup></i>-order cumulant of random variables <i><b>x</b>=(x<sub>1</sub>,,x<sub>n</sub>)</i> is defined as the coefficient of <i><b>&kappa;</b>=(&kappa;<sub>1</sub>,,&kappa;<sub>n</sub>)</i>&nbsp;',...
                   'in the Taylor series expansion of the cumulant generating function:','<br><br>',...
                   '<i>K(<b>&kappa;</b>)=log M(<b>&kappa;</b>)</i>','<br><br>',...%'<i>K(<b>&kappa;</b>)=log&Epsilon;{e<sup>&lt;<b>&kappa;</b>,<b>x</b>&gt;</sup>}</i>','<br><br>',...
                   'To compare, the moment generating function is the following:','<br><br>',...  
                   '<i>M(<b>&kappa;</b>)=&Epsilon;{e<sup>&lt;<b>&kappa;</b>,<b>x</b>&gt;</sup>}</i>','<br><br>',...%'<i>M(<b>m<sub>x</sub></b>)=&Epsilon;{e<sup>&lt;<b>m<sub>x</sub></b>,<b>x</b>&gt;</sup>}</i>','<br><br>',...
                   'Therefore, the <i>n<sup>th</sup></i>-order cumulants can be inferred in terms of its joint moments of orders up to n as follows:','<br><br>',...
                   '<i>Equation (5)</i>','<br><br>',...
                   'where <i>U<sub>p=1</sub><sup>q</sup>I<sub>p</sub>=I</i> denotes summation over all partitions of set I. See Table A1 from Mendel et al (1991). In addition, a list of key properties are shown in the Equation Panel shown.&nbsp;',...
                   'As explained previsouly, cross-terms (cross-talks between many fluorophores) are present in moments and absent in cumulants. This difference is formulated by property 3 which is exclusive to cumulants (can be easily demonstrated using  Definition ).','<br><br>',...
                   'Returning to <i>I(<b>r</b>,t)</i>, the intensity distribution measured over time on a detector pixel <b>r</b> of a sample composed of M independetly fluctuating emitters can be written as:','<br><br>',...
                   '<i>Equation (1)</i>','<br><br>',... 
                   'The <i>n<sup>th</sup></i> order cumulants is described by:','<br><br>',...
                   '<i>Equation (6)</i>','<br><br>',...
                   '<i>&epsilon;<sub>k</sub><sup>n</sup>U<sup>n</sup>(<b>r</b>-<b>r</b><sub>k</sub>)</i> contains information about the brightness <i>&epsilon;<sub>k</sub><sup>n</sup></i>, location <i><b>r</b><sub>k</sub></i>&nbsp;',...
                   'and induced point-spread function <i>U<sup>n</sup>(<b>r</b>)</i> of the fluorophore k. It is straightforward to notice that the position of the fluorophore, as described in&nbsp;',...
                   '<i>I(<b>r</b>,t)</i>, is unchanged and thus <i>&kappa;<sub>n</sub>{I(<b>r</b>,t)}</i>  does not affect the true location of fluorophores. We can also notice that the&nbsp;',...
                   'point-spread function <i>U(<b>r</b>-<b>r</b><sub>k</sub>)</i> has been replaced by <i>U<sup>n</sup>(<b>r</b>-<b>r</b><sub>k</sub>)</i>. If we approximate the point-spread function&nbsp;',...
                   '<i>U(<b>r</b>)</i> by a Gaussian function, we obtain:','<br><br>',...
                   '<i>U(<b>r</b>)=exp(-r<sup>2</sup>/2&sigma;<sup>2</sup>)</i>    and &nbsp;&nbsp;&nbsp;',...
                   '<i>U(<b>r</b>)=exp(-r<sup>2</sup>/2(&sigma;/&radic;n)<sup>2</sup>)</i>','<br><br>',...
                   'In that case, the point-spread function of <i>&kappa;<sub>n</sub>{I(<b>r</b>,t)}</i> becomes thinner by a factor &radic;n and as consequence, there is a resolution improvement of a factor&nbsp;',...
                   '&radic;n in <i>&kappa;<sub>n</sub>{I(<b>r</b>,t)}</i> as compared to I(<b>r</b>,t). In addition, due to Property 2, the temporally constant background was in theory removed.&nbsp;',...
                   'Finally, since <i>&kappa;<sub>n</sub>{s<sub>k</sub>(t)}(<b>&tau;</b>)</i> is neither necessary for resolution improvement or background suppression, we arbitrarily compute&nbsp;',...
                   '<i>&kappa;<sub>n</sub>{I(<b>r</b>,t)}(<b>0</b>)</i> for an impressively fast computation (3-4 seconds for <i>n={1,2,3,4,5,6,7}</i>).','<br><br>',...
                   'The cumulants <i>&kappa;<sub>n</sub>{I(<b>r</b>,t)}(<b>0</b>)</i> are presently computed for each pixel detector individually to provide a background-free and noise-reduced super-resolved image. Nevertheless, it is also possible to combine the&nbsp;',...
                   'information of many pixels to even further reduce any time-varying noise and determine inter-pixels values by computing cross-cumulants&nbsp;',...
                   '<i>&chi;&kappa;<sub>n</sub>{I(<b>r</b><sub>1</sub>,t),...,I(<b>r</b><sub>n</sub>,t)}(<b>0</b>)</i>. In this case, the inter-pixel positions <b>r</b> are defined by&nbsp',...
                   '<b>r</b>=<b>r</b><sub>1</sub>+...+<b>r</b><sub>n</sub> / n.','<br>',...
                   'In the case of a 2<sup>nd</sup> order statistics, the cross-cumulants can be written as:','<br><br>',...
                   '<i>Equation (7)</i>','<br><br>',... 
                   'To compare: <i>Equation (8)</i>','<br><br>',...
                   'assuming a Gaussian point-spread function. As shown in the equation above, <i>&chi;&kappa;<sub>2</sub></i> can be easily computed since it equals the temporal cross-correlation&nbsp;',...
                   'of <i>I(<b>r</b><sub>1</sub>,t)</i> with <i>I(<b>r</b><sub>2</sub>,t)</i>. Since time-varying noise, including shot noise, is spatially and temporally uncorrelated&nbsp',...
                   '(noise varies randomly with time and position), the temporal cross-correlation function of noise tends to zero. In addition, the thinner point spread function <i>U<sup>2</sup></i>&nbsp;',...
                   'is now centered at <i><b>r</b>=<b>r</b><sub>1</sub>+<b>r</b><sub>2</sub>/2</i> instead of <i><b>r</b><sub>1</sub></i>, and thus a virtual pixel <i><b>r</b></i> between&nbsp;',...
                   '<i><b>r</b><sub>1</sub></i> and <i><b>r</b><sub>2</sub></i> is computed.','<br><br>',... 
                   'We can further push the reasoning as such: the pixel at location  <i><b>r</b>=<b>r</b><sub>1</sub>+<b>r</b><sub>2</sub> / 2</i> can also be computed&nbsp;',...
                   'with two other neighbouring pixels (i.e. in vertical direction rather than horizontal) <i><b>r</b>=<b>r</b><sub>3</sub>+<b>r</b><sub>4</sub> / 2</i>. We could&nbsp;',...
                   'therefore calculate the pixel value in two different ways to then average them leading to a reduced amount of noise in the new pixel value.&nbsp;',...
                   'We can extend this reasoning to <i>n<sup>th</sup></i> order cross-cumulants where we would need <i>n</i> pixels for the computation and thus have a much higher number of ways of computing&nbsp;',...
                   'the cumulant pixel and averaging some together as described in Dertinger et al. 2009 to even further reduce noise. The resulting <i>n<sup>th</sup></i> order cross-cumulant can thus be described by the following equation:','<br><br>',...
                   '<i>Equation (9)</i> &nbsp;&nbsp;&nbsp;&nbsp; with <i>I(r<sub>S</sub>,t)=I(<b>r</b><sub>1</sub>,t) ... I(<b>r</b><sub>n</sub>,t)</i>','<br><br>',...
                   'Figure 1 shows the comparison of <i>&chi;&kappa;<sub>2</sub>{I(<b>r</b><sub>1</sub>,t),I(<b>r</b><sub>2</sub>,t)}(0)</i> with a spline interpolation of <i>I(<b>r</b>,t<sub>0</sub>)</i>.&nbsp;',...
                   'Fluorophores are seen sharper (due to a thinner point spread function) on <i>&chi;&kappa;<sub>2</sub>{I(<b>r</b><sub>1</sub>,t),I(<b>r</b><sub>2</sub>,t)}(0)=&Epsilon;{I(<b>r</b><sub>1</sub>,t)I(<b>r</b><sub>2</sub>,t+&tau;)}(&tau;=0)</i> than on&nbsp;',...
                   '<i>I(<b>r</b><sub>1</sub>,t=t<sub>0</sub>)</i>. In addition, in <i>&chi;&kappa;<sub>2</sub></i>, noise has been completely removed from I(<b>r</b>,t). Figure 2 and 3 helps understanding why&nbsp;',...
                   'only considering <i>&chi;&kappa;<sub>2</sub>{I(<b>r</b><sub>1</sub>,t),I(<b>r</b><sub>2</sub>,t)}(<b>0</b>)</i> and not <i>&chi;&kappa;<sub>2</sub>{I(<b>r</b><sub>1</sub>,t),I(<b>r</b><sub>2</sub>,t)}(<b>&tau;</b>)</i>,&tau;&isin;R<sup>+</sup>&nbsp;',...
                   'or <i>&int;&chi;&kappa;<sub>2</sub>{I(<b>r</b><sub>1</sub>,t),I(<b>r</b><sub>2</sub>,t)}(<b>&tau;</b>)d<b>&tau;</b></i> is appropriate. Indeed, since there are no practical gain in reducing noise&nbsp;',...
                   'and improving the resolution, computing only <i>&chi;&kappa;<sub>2</sub>(0)</i> is sufficient. Only the first few coefficients (&tau;~0) provide sufficient information: <i>&chi;&kappa;<sub>2</sub>(&tau)</i> rapidly decays toward zero as &tau increases.','<br>',...
                   ''];
    case 2
        htmlStr = ['<div align="justified"><font face="cambria" color="black"><font size = "4">The n<sup>th</sup> order cross-cumulant can be described by the following equation:','<br><br>',...
                   '<i>Equation (1)</i>','<br><br>',...
                   'This equation describes the <i>n<sup>th</sup></i> order cross-cumulant computed and shown in the previous step (Raw Cumulants). The sum in equation (1) is weighted by the product of&nbsp;',...
                   '<i>n</i> PSF-shaped weight factors, called the <i><b>distance factor</i></b>, which depends on the distances <i><b>d<sub>jl</sub></i></b> between <i><b>r<sub>j</sub></i></b> and <i><b>r<sub>l</sub></i></b>,&nbsp;',...
                   '<i>j</i> and <i>l</i> spanning the pixel set used for cross-cumulant computation (see Raw Cumulants). As <i><b>d</i></b> increases, <i><b>r<sub>j</sub></i></b> and <i><b>r<sub>l</sub></i></b> become&nbsp;',...
                   'further apart reducing the value of the product between the <i>n</i> PSF-shaped weight factors up to a certain point when the cross-cumulant <i>&chi;&kappa;<sub>n</sub></i> approaches zero. As a consequence,&nbsp;',...
                   'only nearby pixels (i.e. a small distance d between <i><b>r<sub>j</sub></i></b> and <i><b>r<sub>l</sub></i></b>) can be used to compute cross cumulants so as to reduce as much as possible the error introduced&nbsp;',...
                   'by this weighting/distance factor. However, as the order of SOFI grows, so does the error introduced by the weighting factor.','<br><br>',...
                   'Indeed, Figure 1 depicts a <i>4<sup>th</sup></i> order 1D SOFI grid where light gray squares with single letters correspond to physical pixels of the recording camera and light blue squares with four&nbsp;',...
                   'letters to inter-pixels computed with cross-cumulants. The error introduced in this case by the distance factor can be expressed in the following terms: the inter-pixel exactly between physical pixel&nbsp;',...
                   'A and B (pixel AABB) will have a different weighting factor than the one closer to A (pixel AAAB) since the distance between them and the physical pixels is different. Therefore, both inter-pixels&nbsp;',...
                   '(AAAB and AABB) have distinct weighting factor.','<br><br>',...
                   'An elegant way to resolve this issue is to multiply each cross-cumulant pixel by the inverse of its corresponding distance factor (which we can compute by estimating the PSF U(r) of the optical system).&nbsp;',...
                   'The cross-cumulants after flattening become:','<br><br>',...
                   '<i>Equation (2)</i>','<br><br>',...
                   'Nevertheless, the estimation of <i>U(<b>r</b>)</i> can quite often be cumbersome and based on large approximations. Therefore we have developed a simple and robust method in order to correct for the&nbsp;',...
                   'weighting factor which gives either a better or similar result as compared to estimating the inverse of the distance factor.','<br><br>',... 
                   'Figure 2.a. depicts a <i>2<sup>nd</sup></i> order <i>3x3</i> SOFI grid where light gray squares with single letters again correspond to the physical pixels on the camera and light blue squares with two&nbsp;',...
                   'letters to the inter-pixels (or virtual pixels) computed with cross-cumulants. This grid can be decomposed into two separate grids, a grid containing all the physical pixels and another containing all the inter-pixels, shown&nbsp;',...
                   'in Figure 2.b and 2.c respectively. Both grids describe the same confined region in the sample and should hence share the same variance. Therefore, by multiplying the inter-pixel grid (Figure 2.c.) with&nbsp;',...
                   'the ratio between the variance of the physical pixels and the variance of the virtual pixels, the inter-pixels values are brought in the same range of the physical pixel values removing the weighting factor&rsquo;s effect.','<br>',...
                   '<br> '];
    case 3
        htmlStr = ['<div align="justified"><font face="cambria" color="black"><font size = "4">At this point, noise and background were either eliminated or reduced, and the resolution was improved by <i>&radic;n</i>. It is nevertheless very important to notice that the brightness <i>&epsilon;<sub>k</sub></i> of each fluorophore&nbsp;',... 
                   'is greatly affected in the process of cumulant computation which, at high orders, alters dramatically the contrast of the SOFI image: small differences in brightness between fluorophores are severely amplified. For example, an&nbsp;',...
                   'emitter that has a 2-fold larger molecular brightness <i>&epsilon;<sub>k</sub></i> than another will appear 2<sup>n</sup> times brighter in the n<sup>th</sup> order SOFI image than the other. In addition, an emitter that does not fluctuate&nbsp;',...
                   'over time will yield a null cumulant and will thus not appear in the SOFI image. These issues will thereafter be respectively referred to as <b>amplified brightness</b> and <b>blinking heterogeneities</b>.','<br><br>',... 
                   'The flattened n<sup>th</sup> order cross-cumulant can be described by the following equation:','<br><br>',...
                   '<i>Equation (1)</i>','<br><br>',...
                   'Where <i>s<sub>k</sub>(t)</i> is a time-varying stochastic signal that equals 1 when the emitter is in the on-state and &xi;&isin;[0,1[ when it is in the off-state. The relative durations of the on and off-states are respectively:','<br><br>',...
                   '<i>Equation (2)</i>','<br><br>',...
                   'This blinking behaviour <i>s<sub>k</sub>(t)</i> can thus be described by:','<br><br>',...
                   '<i>s<sub>k</sub>(t)=(1-&xi;<sub>k</sub>)f<sub>k</sub>(t)</i>','<br><br>',...
                   '<i>f<sub>k</sub>(t)</i> defined by a Bernouilli distribution with probability <i>&rho;<sub>on</sub></i>. In other words, the fluorophore is either in the on state with probability <i>&rho;<sub>on</sub></i> or in the off-state with',...
                   'probability <i>1-&rho;<sub>on</sub></i>. Therefore, the cumulant the stochastic signal <i>s<sub>k</sub>(t)</i> is:','<br><br>',...
                   '<i>Equation (3)</i>','<br><br>',...
                   'Combining this result with equation (1) leads to the following n<sup>th</sup> order cross-cumulant:','<br><br>',...
                   '<i>Equation (4)</i> &nbsp;&nbsp;&nbsp;&nbsp; with <i>I(<b>r</b><sub>S</sub>,t)=I(<b>r</b><sub>1</sub>,t) ... I(<b>r</b><sub>n</sub>,t)</i>','<br><br>',...
                   'Where both <i>&epsilon;<sup>n</sup></i> and <i>f<sub>n</sub></i> were written to vary according to spatial coordinates instead of individual fluorophores (i.e. <i>&epsilon;(<b>r</b>)&asymp;&sum;&epsilon;<sub>k</sub></i>).','<br><br>',...
                   'In order to correct for the amplified brightness <i>&epsilon;<sub>k</sub><sup>n</sup></i>, the cumulants are deconvolved with an estimate of the point-spread function.',...
                   'Assuming a perfect deconvolution, the result can be interpreted as follows:','<br><br>',...
                   '<i>Equation (5)</i> &nbsp;&nbsp;&nbsp;&nbsp; with <i>I(<b>r</b><sub>S</sub>,t)=I(<b>r</b><sub>1</sub>,t) ... I(<b>r</b><sub>n</sub>,t)</i>','<br><br>',...
                   'Since each point-spread function has been reduced to a Dirac pulse, taking the n<sup>th</sup> root linearizes the brightness response without cancelling the resolution improvement of the cumulant. The linearized cumulant can be expressed by:','<br><br>',...
                   '<i>Equation (6)</i> &nbsp;&nbsp;&nbsp;&nbsp; with <i>I(<b>r</b><sub>S</sub>,t)=I(<b>r</b><sub>1</sub>,t) ... I(<b>r</b><sub>n</sub>,t)</i>','<br><br>',...
                   ''];
    case 4
        htmlStr = ['<div align="justified"><font face="cambria" color="black"><font size = "4">The linearized cross-cumulant is defined by the following equation:','<br><br>',...
                   '<i>Equation (1)</i>','<br><br>',...
                   'In order to mask artifacts introduced by deconvolution (see Linearization), small values are truncated and the image is reconvolved with a scaled version of the PSF <i>U(<b>r</b>)</i> of the optical system.','<br><br>',...
                   'The scale of the point-spread function used for reconvolution is chosen so that the scaled OTF has the same frequency support than the n<sup>th</sup> order cross-cumulant equivalent optical transfer function. In fact, the Fourier transform of a product of n functions&nbsp;',...
                   'equals the convolution between the Fourier transform of each function. In addition, since the support of the convolution of an OTF with itself has twice its original support, the support of the cumulant OTF has n&nbsp;',... 
                   'times the support of the systems OTF, and therefore, the image is reconvolved by <i>U(n<b>r</b>)</i>:','<br><br>',...
                   '<i>Equation (2)</i>','<br><br>',...
                   'Assuming a Gaussian point-spread function, the resolution is improved by a factor n (instead of <i>&radic;n</i> as it was initially).','<br><br>',... 
                   'Before linearization, the cross-cumulant was described by:','<br><br>',...
                   '<i>Equation (3)</i>','<br><br>',...
                   'After linearization and convolution, the cross-cumulant is now expressed by:','<br><br>',...
                   '<i>Equation (4)</i>','<br><br>',...
                   'Resulting in an improved resolution (by a factor <i>&radic;n</i> between the two) and a linearized brightness &epsilon; resolving the amplified brightness issue described in previous tutorial steps.','<br>',...
                   ''];
    case 5
        htmlStr = ['<div align="justified"><font face="cambria" color="black"><font size = "4">The flattened n<sup>th</sup> order cross-cumulant can be described by the following equation:','<br><br>',...
                   '<i>Equation (1)</i>','<br><br>',...
                   'as shown in the tutorial step <i>Linearization</i>.','<br><br>',...
                   'Since neither <i>&epsilon;(<b>r</b>)</i> nor <i>&rho;<sub>on</sub></i> vary with the order of the&nbsp;',...
                   'cumulant <i>n</i>, combining several cumulants allowed us to determine the molecular density N(<b>r</b>),&nbsp;',...
                   'the spatial distribution of molecular brightness <i>&epsilon;(<b>r</b>)&asymp;&sum;&epsilon;<sub>k</sub></i> and &nbsp;',...
                   'the on-time ratio map <i>&rho;(<b>r</b>)&asymp;&sum;&rho;<sub>on,k</sub></i>) of fluorophores each with&nbsp',...
                   'its own level of accuracy (<i>&rho;<sub>on</sub></i> having the highest) as described in S. Geissbuehler et al. 2012.','<br><br>',...
                   'As described by equation (1), the n<sup>th</sup> order linearized cumulants are proportional to &nbsp;',...
                   '<i>f<sub>n</sub></i> which has been shown in the help menu Linearization to be a polynomial of order&nbsp;',...
                   '<i>n</i>, thus having <i>n</i> roots for <i>&rho;<sub>on</sub></i>. In other words, after brightness linearization,&nbsp;',...
                   '<i>|f<sub>n</sub>|<sup>(1/n)</sup></i> introduces artifacts in the resulting image due to its zeros. However,&nbsp;',...
                   'using the on-ratio map <i>&rho;<sub>on</sub></i>, we can easily determine where <i>|f<sub>n</sub>|<sup>(1/n)</sup></i> &nbsp;',...
                   'will drop towards zero and fill these locations with the (n-1)<sup>th</sup> order linearized cumulants&nbsp;',...
                   '(instead of the actual n<sup>th</sup> order one). Indeed, according to Figure 1, <i>|f<sub>n</sub>|<sup>(1/n)</sup></i> &nbsp;',...
                   'zeros&#32; always correspond to high <i>|f<sub>n-1</sub>|<sup>(1/n-1)</sup></i> values.','<br><br>',...
                   'Correction for this artefact is introduced in equation (2) to yield the bSOFI image that can be roughly approximated by:','<br><br>',...
                   '<i>Equation (1)</i>','<br>',...
                   ''];
    otherwise
end

end






