%Example of the SOFI analysis of an image sequence.

%Copyright  2012 Marcel Leutenegger et al, cole Polytechnique Fdrale de Lausanne,
%Laboratoire d'Optique Biomdicale, BM 5.142, Station 17, 1015 Lausanne, Switzerland.
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

%% Image TIFF file or image sequence.
%
stack='example.tif';

%% Analyze the image sequence.
%
[sofi,grid]=sofiCumulants(stack);
[sofi,fwhm]=sofiFlatten([],sofi,grid);
[ratio,density,brightness]=sofiParameters(sofi);   % need flat cumulants to get parameters
sofi=sofiLinearize(sofi,fwhm);                     % "blind" linearization (no parameters)
img=sofiBalance(sofi,ratio);                       % use 3rd order in minima of 4th order

%% Display the results.
%
for n=1:4
   imagesp(sofi{n},sprintf('%d. order',n));
end
imagesp(img,'Balanced');
