%%  OpenNanoPore 1.0
%%  Main, where the fun begins!
%%  Input Parameters - To change!!!!

ExperimentTitle='Test';     % Choose a title for your experiment
RawSignal=RawSignal;               % Name of the variable containing the signal to analyze
delta=0.2;                  % most likely and smallest current drop
sigma=0.04;                 % standard deviation of the baseline (can use the MATLAB fonction std)
SamplingFrequency=100e3;    % Sampling frequencing of signal to analyse
S=5;                        % S Coefficient for recursive low pass filter=> threshold S*sigma  
E=0;                        % E Coefficient for recursive low pass filter
%%%%
ImpulsionLimit=10;          % Every event smaller than this amount of samples is considered to be an impulsion
IncludedBaseline=100;       % Number of baseline points included for the CUSUM fit
IncludedBaselinePlots=50;   % Number of baseline points inlcuded for plotting events
TooMuchLevels=10;           % You can turn off the small while loop by putting a zero here!
time_units='ms';            % choose from: us, ms, s
current_units='nA';         % choose from: pA, nA
Normalize=1;                % Normalizes the baseline to 0 for the plots. Choose from Yes=1, No=0



%%

f=filesep;
p=mfilename('fullpath');
direct=fileparts(p);
addpath([direct f 'Scripts']);

fprintf('The signal has a length of %i samples, beginning calculating...hold on...\n',length(RawSignal))

%%  Detection of start and end points of an event: 
%RoughEventLocations: x(i,1)=startpoint of event i, x(i,2)=Endpoint of event i, x(i,3)=length of event i
tic
%  Recursive lowpass filter method:
%Arguments in recursive_low_passRaw: (RawSignal,StartCoeff,EndCoeff,FilterCoeff);
[RoughEventLocations]=recursive_low_pass(RawSignal,S,E,0.999);
timeFiltering=toc;
fprintf('Recursive LowPass event detection done! Needed %f seconds\n',timeFiltering)

%%  Precise Event Detection and Segmentation of levels
%Initialization
CusumParameters=[delta sigma Normalize ImpulsionLimit IncludedBaseline TooMuchLevels IncludedBaselinePlots 1];
[EventDatabase]=event_detection(RawSignal, CusumParameters, RoughEventLocations);
timeEventDetection=toc;
fprintf('The event detection and segmentation part has taken %f seconds to complete.\n',timeEventDetection)

tic
%%  Concatenate Signal
[ConcatenatedEvents ConcatenatedFits event]=concatenate_events(RawSignal, EventDatabase, IncludedBaselinePlots,Normalize);
timeConcatenating=toc;
fprintf('Concatenating the events took %f seconds to complete. Nearly done, hold on...\n',timeConcatenating)

if(isdir(ExperimentTitle)==0)
mkdir(ExperimentTitle)      %Creates folder containing the plots
end

EventDatabase=event;

%%  Save Global Information File
outputstring=sprintf('Analysis done.\nComputing time was: %f s\n', timeEventDetection+timeFiltering+timeConcatenating);
str2=AnalysisInfos(EventDatabase);
introText=[outputstring str2];
out=fopen([ExperimentTitle filesep 'Global_Informations.txt'],'w');
fprintf(out,'%s', introText);
fclose(out);

%% Saving Variables
save([ExperimentTitle filesep 'ExperimentData.mat'], 'EventDatabase', 'ConcatenatedEvents','ConcatenatedFits','delta','sigma','IncludedBaselinePlots','SamplingFrequency','time_units','current_units');
EventDatabase=getArea(ExperimentTitle);
save([ExperimentTitle filesep 'ExperimentData.mat'], 'EventDatabase', 'ConcatenatedEvents','ConcatenatedFits','delta','sigma','IncludedBaselinePlots','SamplingFrequency','time_units','current_units');
fprintf('Total time needed was %f seconds\n',timeEventDetection+timeFiltering+timeConcatenating)
clearvars -except EventDatabase RawSignal ConcatenatedEvents ConcatenatedFits delta sigma