%%  x_level_events:
% This function searches for events with x-levels and returns a vector
% containing the indexes of those events. It can then be used as an input for other
% functions, as RemoveEvents or ExtractEvents.
% 
% Use:
% indexes=x_level_events(x)

function indexes=x_level_events(x)
%% IMPORT
[FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
a=load([PathName FileName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end
%%
EventDatabase=a.EventDatabase;

indexes=[];
EventDatabase_Filtered=[];
for i=1:length(EventDatabase)
    if(EventDatabase(i).NumberOfLevels==x)
    indexes=[indexes i];
    end
end

end