%% Scatter Plot 
% Produces scatter plots (Dwell time vs. Current blockage) of an event
% database.
% 
% Use: 
% scatterplot(EventDatabase, SamplingFrequency, Units).

function scatterplot()

%% IMPORT
[FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
a=load([PathName FileName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end
%%

EventDatabase=a.EventDatabase;
SamplingFrequency=a.SamplingFrequency; %100kHz
time_units=a.time_units;
current_units=a.current_units;

units=1e3;
switch time_units
    case 'us' 
        units=1e6;
    case 'ms' 
        units=1e3;
    case 's' 
        units=1;
end


L=EventDB2LTable(EventDatabase);
x_time=L(:,5)./SamplingFrequency.*units;
h=figure;
scatter(x_time,L(:,6),'o','r','filled');
xlabel(['Dwell Time [' time_units ']']);
ylabel(['Current Blockage [' current_units ']']);

datacursormode on

% Get the handle to the data cursor.
menu = findall(get(gcf,'Children'),'Type','uicontextmenu');
menuCallback = get(menu,'Callback');
dataCursor = menuCallback{2};

% Get the coordinates if a datatip exists.
info_before=[0 0];
%flag=1;
while(ishghandle(h))
pause(1)
%k=waitforbuttonpress;
info = getCursorInfo(dataCursor);
if ~isempty(info) && info.Position(1)~=info_before(1) && info.Position(2)~=info_before(2)
index=find(L(:,6)==info.Position(2) & x_time==info.Position(1));
eventnum=L(index,1);
levelnum=L(index,2);
%%  Event
info_before(1)=info.Position(1);
info_before(2)=info.Position(2);
fprintf('x: %f, y: %f\nEvent number %i, Level number %i\n\n',info.Position(1),info.Position(2),eventnum,levelnum);
end
end
end
