%% Plots Events
% This function plots the events of choice.
% plotEvents(number, format)
% Use: 
%
% number='All' or a vector of event numbers to plot
% format=One of the Matlab supported fileformats below:
%
%
% 'ai'  :   Adobe Illustrator `88bmp
% 
% 'bmp' :   Windows bitmapemf
% 
% 'emf' :   Enhanced metafileeps
% 
% 'eps' :   EPS Level 1fig
% 
% 'fig' :   MATLAB figure (invalid for Simulink block diagrams)jpg
% 
% 'jpg' :   JPEG image (invalid for Simulink block diagrams)m
% 
% 'm'   :   MATLAB file (invalid for Simulink block diagrams)pbm
% 
% 'pbm' :   Portable bitmappcx
% 
% 'pcx' :   Paintbrush 24-bitpdf
% 
% 'pdf' :   Portable Document Formatpgm
% 
% 'pgm' :   Portable Graymappng
% 
% 'png' :   Portable Network Graphicsppm
% 
% 'ppm' :   Portable Pixmaptif
% 
% 'tif' :   TIFF image, compressed
%
% 'tiffn'   :   TIFF image, uncompressed


function plotEvents(number, format)
%% IMPORT
[FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
a=load([PathName FileName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end
FolderName = uigetdir('','Choose where the plots should be saved..');
EventDatabase=a.EventDatabase;
ConcatenatedEvents=a.ConcatenatedEvents;
ConcatenatedFits=a.ConcatenatedFits;
IncludedBaselinePlots=a.IncludedBaselinePlots;
delta=a.delta;
sigma=a.sigma;
SamplingFrequency=a.SamplingFrequency;
time_units=a.time_units;
current_units=a.current_units;
units=1e3;
switch time_units
    case 'us' 
        units=1e6;
    case 'ms' 
        units=1e3;
    case 's' 
        units=1;
end

if(ischar(number))
if(strcmp(number,'All'))
% String case
i=1:length(EventDatabase);
end
else
% Vector case
i=number;
end

for i=i
% plotting loop
startp=EventDatabase(i).ConcatenatedStartCoordinates-IncludedBaselinePlots+1;
endp=EventDatabase(i).ConcatenatedStartCoordinates+length(EventDatabase(i).AllLevelFits)-1+IncludedBaselinePlots;
xbase=1:(endp-startp+1);
x1=xbase./(SamplingFrequency).*units;

fig=figure;
plot(x1,ConcatenatedEvents(startp:endp),'b','Linewidth',1.5);
hold on
plot(x1,ConcatenatedFits(startp:endp),'r','Linewidth',1.5);
xlabel(['Time [' time_units ']']);
ylabel(['Current [' current_units ']']);
title(['Event ' int2str(i) ': This event contains ' int2str(EventDatabase(i).NumberOfLevels) ' levels']);
saveas(fig,[FolderName filesep 'Event_' int2str(i)],format);
close(fig)
end
end