%%  OpenNanoPore 1.0
%%  Main, where the fun begins!
%%  Input Parameters - To change!!!!

ImpulsionLimit=10;                              % Every EventDatabase smaller than this amount of samples is considered to be an impulsion
IncludedBaseline=100;                            % How much baseline should be inlcuded for CUSUM?
IncludedBaselinePlots=50;                      % How much baseline should be inlcuded for plotting events?
xLabel='Time [ms]';
yLabel='Current';
TooMuchLevels=10;                  % You can turn off the small while loop by putting a zero here!
Normalize=1;
s1=sprintf('The signal has a length of %i samples\n',length(RawSignal));

%%  Detection of start and end points of an EventDatabase: 
%RoughEventLocations: x(i,1)=startpoint of EventDatabase i, x(i,2)=Endpoint of EventDatabase i, x(i,3)=length of EventDatabase i
tic
%  Recursive lowpass filter method:
%Arguments in recursive_low_passRaw: (RawSignal,StartCoeff,EndCoeff,FilterCoeff);
[RoughEventLocations]=recursive_low_pass(RawSignal,5,0,0.999);
timeFiltering=toc;
%fprintf('Recursive LowPass EventDatabase detection done! Needed %f seconds\n',timeFiltering)

%%  Precise EventDatabase Detection and Segmentation of levels
%Initialization
CusumParameters=[delta sigma Normalize ImpulsionLimit IncludedBaseline TooMuchLevels IncludedBaselinePlots, 1];
[EventDatabase]=event_detection(RawSignal, CusumParameters, RoughEventLocations);
timeEventDetection=toc;
s2=sprintf('The EventDatabase detection and segmentation part has taken %f seconds to complete.\n',timeEventDetection);

tic
%%  Concatenate Signal
[ConcatenatedEvents ConcatenatedFits event]=concatenate_events(RawSignal, EventDatabase, IncludedBaselinePlots, Normalize);
timeConcatenating=toc;
s3=sprintf('Concatenating the events took %f seconds to complete. Nearly done, hold on...\n',timeConcatenating);

if(isdir(ExperimentTitle)==0)
mkdir(ExperimentTitle)      %Creates folder containing the plots
end

EventDatabase=event;


%% Saving Variables
save([ExperimentTitle filesep 'ExperimentData.mat'], 'EventDatabase', 'ConcatenatedEvents','ConcatenatedFits','delta','sigma','IncludedBaselinePlots','SamplingFrequency','time_units','current_units');
EventDatabase=getArea(ExperimentTitle);
save([ExperimentTitle filesep 'ExperimentData.mat'], 'EventDatabase', 'ConcatenatedEvents','ConcatenatedFits','delta','sigma','IncludedBaselinePlots','SamplingFrequency','time_units','current_units');
s4=sprintf('Total time needed was %f seconds\n',timeEventDetection+timeFiltering+timeConcatenating);
s5=sprintf('A total of %i events have been detected',length(EventDatabase));
outputstring=sprintf('Analysis done.\nComputing time was: %f s\n', timeEventDetection+timeFiltering+timeConcatenating);

%clear