%% Histogram
% This function plots a histogram of the current blockages of an event
% database. The variable bin allows for adjustment of the bin-size
% 
% Use:
% histogram(number_of_bins), The script prompts you to choose an event
% database automatically.

function histogram(bin)

%% IMPORT
[FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
a=load([PathName FileName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end
EventDatabase=a.EventDatabase;
current_units=a.current_units;
%%

L=EventDB2LTable(EventDatabase);
figure
hist(L(:,6),bin);
xlabel(['Current blockage [' current_units ']'])
ylabel('Counts')
end