%%  Function RemoveEvents: RemoveEvents(FolderName,number,'Threshold')
%   This function removes events from the database. First you can remove
%   events from the database using their event number. In this case the
%   argument is simply a vector with the desired event numbers => 1). 
%   Instead of removing events based on their event number, the
%   'Threshold' method removes all events longer than a threshold given in
%   argument two. This threshold is given in the time domain based on units and
%   sampling frequencies of the analysis. => 2)
%   This function produces a new .mat file called in the location of your choice. 
%   
%   Use:
%   1) RemoveEvents(numbers)
%   2) RemoveEvents(threshold, 'Threshold')

function RemoveEvents(numbers,varargin)
f=filesep;
if(nargin>=4)
    FolderName=varargin{1};
    InputName=varargin{2};
    OutputName=varargin{3};
    a=load([FolderName f InputName]);
elseif(nargin==1 || nargin==2)
    [FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
    a=load([PathName FileName]);
elseif(nargin==3)
    FolderName=varargin{1};
    InputName=varargin{2};
    a=load([FolderName f InputName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end
end

EventDatabase=a.EventDatabase;
ConcatenatedEvents=a.ConcatenatedEvents;
ConcatenatedFits=a.ConcatenatedFits;
IncludedBaselinePlots=a.IncludedBaselinePlots;
delta=a.delta;
sigma=a.sigma;
SamplingFrequency=a.SamplingFrequency;
time_units=a.time_units;
current_units=a.current_units;


units=1e3;
switch time_units
    case 'us' 
        units=1e6;
    case 'ms' 
        units=1e3;
    case 's' 
        units=1;
end

if nargin>5
    errordlg('Too much input arguments, please give only 3 arguments','Error');
end

if nargin==5 || nargin==2
    if(~strcmp(varargin{1}, 'Threshold')&&nargin==2)
    errordlg('The last argument must be ''Threshold'', if you want to use the threshold method', 'Error');
    return
    else
       %Executed when threshold method used
       for i=length(EventDatabase):-1:1
           leng=EventDatabase(i).StartAndEndPoint(2)-EventDatabase(i).StartAndEndPoint(1);
           leng=leng/SamplingFrequency*units;
           if (leng>numbers)
                startp=EventDatabase(i).ConcatenatedStartCoordinates-50+1;
                endp=EventDatabase(i).ConcatenatedStartCoordinates+length(EventDatabase(i).AllLevelFits)-1+50;
                ConcatenatedEvents(startp:endp)=[];
                ConcatenatedFits(startp:endp)=[];
                EventDatabase(i)=[];
                % correct the concat coordinates
                for j=i:length(EventDatabase)
                EventDatabase(j).ConcatenatedStartCoordinates=EventDatabase(j).ConcatenatedStartCoordinates-(endp-startp+1);
                end
           end
       end
    end  
end

if nargin==4||nargin==1 ||nargin==3
    numbers=sort(unique(numbers),'descend');
    for i=numbers
                startp=EventDatabase(i).ConcatenatedStartCoordinates-50+1;
                endp=EventDatabase(i).ConcatenatedStartCoordinates+length(EventDatabase(i).AllLevelFits)-1+50;
                ConcatenatedEvents(startp:endp)=[];
                ConcatenatedFits(startp:endp)=[];
                EventDatabase(i)=[];
                % correct the concat coordinates
                for j=i:length(EventDatabase)
                EventDatabase(j).ConcatenatedStartCoordinates=EventDatabase(j).ConcatenatedStartCoordinates-(endp-startp+1);
                end       
    end  
end

if(nargin>=4)
save([FolderName f OutputName '.mat'], 'EventDatabase', 'ConcatenatedEvents','ConcatenatedFits','delta','sigma','IncludedBaselinePlots','SamplingFrequency','time_units', 'current_units');
else
uisave({'EventDatabase', 'ConcatenatedEvents','ConcatenatedFits','delta','sigma','IncludedBaselinePlots','SamplingFrequency','time_units', 'current_units'},'newEventDatabase');
end

end