%% Plot Concatenated Events
% This function produces an overlap plot of the concatenated fits and the
% concatenated events.
% Sampling frequency and time units are based on the settings provided
% during analysis.
% 
% Use:
% PlotConcatenated, The script prompts you to choose an event
% database automatically.;

function PlotConcatenated()
%% IMPORT
[FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
a=load([PathName FileName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end
EventDatabase=a.EventDatabase;
current_units=a.current_units;
%%

ConcatenatedEvents=a.ConcatenatedEvents;
ConcatenatedFits=a.ConcatenatedFits;

SamplingFrequency=a.SamplingFrequency;
time_units=a.time_units;

units=1e3;
switch time_units
    case 'us' 
        units=1e6;
    case 'ms' 
        units=1e3;
    case 's' 
        units=1;
end

x=1:length(ConcatenatedEvents); x=x./SamplingFrequency.*units;

plot(x,ConcatenatedEvents,'b');
hold on
plot(x,ConcatenatedFits,'r');
xlabel(['Time [' time_units ']']);
ylabel(['Current [' current_units ']']);
title('Concatenated Events')

end