%%  Level Info to text
% Used by GUI.m to convert the informations about the levels of an event
% into a useable string.

function string=Level2String(level,frequency, unit_chosen, current_unit)
[a ~]=size(level);
f=frequency;    %acquisition frequency
units=1e3;
format='%1.3f';
switch unit_chosen
    case 'us' 
        units=1e6;
        format='%1.0f';
    case 'ms' 
        units=1e3;
        format='%1.3f';
    case 's' 
        units=1;
        format='%1.1e';
end
string='';
for i=1:a
s=sprintf(['Level %i has a length of ' format ' %s and a current drop of %6.3f %s\n'],level(i,1),level(i,6)/f*units,unit_chosen,level(i,2), current_unit);
string=[string s];
end
end
