%% Finds double detections of events
% This function identifies doubles and returns their event numbers. It is
% then subsequently possible to remove those events using the output of this
% function as the input of RemoveEvents.
% Use:
% event_doubles=FindDoubles()


function event_doubles=FindDoubles(varargin)
if(nargin==0)
%% IMPORT
[FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
a=load([PathName FileName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end
%%
EventDatabase=a.EventDatabase;
end
if(nargin==1)
    EventDatabase=varargin{1};
end
event_doubles=[];
temp_start=EventDatabase(1).StartAndEndPoint(1);
temp_end=EventDatabase(1).StartAndEndPoint(2);
for i=2:length(EventDatabase)
   if(EventDatabase(i).StartAndEndPoint(1)>=temp_start && EventDatabase(i).StartAndEndPoint(1)<=temp_end)
       event_doubles=[event_doubles i];
       continue
   end
temp_start=EventDatabase(i).StartAndEndPoint(1);
temp_end=EventDatabase(i).StartAndEndPoint(2);  
end
end