%%  Function RemoveEvents: ExtractEvents(FolderName,number,'Threshold')
%   Use this function to extract individual events from the database. The
%   input is a vector or scalar of event numbers to be extracted from the database. 
%   
%   Use:
%   1) RemoveEvents(numbers)


function ExtractEvents(numbers)

[FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
a=load([PathName FileName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end

EventDatabase=a.EventDatabase;

if nargin>1
    errordlg('Too much input arguments, please give only 3 arguments','Error');
end

if nargin==1
    x=1:length(EventDatabase);
    x(numbers)=[]; 
    RemoveEvents(x,PathName,FileName);
end


end