%%  Event Database to L-Table
% This function converts an event database (structure array) to an
% level-table (matrix). The level-table is called L-table and contains the
% following informations in each row:
% [EventNumber LevelNumber StartPoint EndPoint Length CurrentDropRelative]
% 
% Use:
% L=EventDB2LTable, The script prompts you to choose an event
% database automatically. Alternatively you can use an EventDatabase from
% the workspace as the input for this function.
 

function L=EventDB2LTable(varargin)

%% IMPORT
if(nargin==0)
[FileName,PathName,FilterIndex] = uigetfile('*.mat','Select event database...');
a=load([PathName FileName]);
if(~isfield(a, 'EventDatabase'))
    errordlg('Please specify a .mat file containing an event database','Error')
    return
end
event=a.EventDatabase;
else
    event=varargin{1};
end
%%

L=[];
for i=1:length(event)
    for j=1:event(i).NumberOfLevels
        L=[L; i j event(i).Levels(j,4:6) event(i).Levels(j,2)];
    end
end
end