
function varargout = GUI_Statistics(varargin)
% GUI_STATISTICS MATLAB code for GUI_Statistics.fig
%      GUI_STATISTICS, by itself, creates a new GUI_STATISTICS or raises the existing
%      singleton*.
%
%      H = GUI_STATISTICS returns the handle to a new GUI_STATISTICS or the handle to
%      the existing singleton*.
%
%      GUI_STATISTICS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GUI_STATISTICS.M with the given input arguments.
%
%      GUI_STATISTICS('Property','Value',...) creates a new GUI_STATISTICS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before GUI_Statistics_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to GUI_Statistics_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help GUI_Statistics

% Last Modified by GUIDE v2.5 02-Aug-2012 10:56:42

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @GUI_Statistics_OpeningFcn, ...
                   'gui_OutputFcn',  @GUI_Statistics_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before GUI_Statistics is made visible.
function GUI_Statistics_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GUI_Statistics (see VARARGIN)
set(hObject, 'Name', 'OpenNanopore-Statistics')

% Choose default command line output for GUI_Statistics
handles.output = hObject;
handles.list=[];
handles.DBList=[];
handles.selected_index_DB=1;
handles.selecTHING=1;
% Update handles structure
guidata(hObject, handles);
f=filesep;
p=mfilename('fullpath');
direct=fileparts(p);
addpath([direct f 'Scripts']);

%% Event Axes
epfl=importdata(['Scripts' f 'EPFL.png']);
axes(handles.event)
pos=get(handles.event,'Position');
cla
text(pos(3)/2,pos(4)/2,'Open a database to begin...','Color','white','Units','pixels','BackgroundColor','blue', 'FontUnits','pixels','Fontsize',15,'HorizontalAlignment','center')
set(gca,'XTick',[],'YTick',[])

%% Scatter Axes
axes(handles.scatter)
pos=get(handles.scatter,'Position');
cla
plot(sin(linspace(-2*pi,2*pi,1000)),'LineWidth',5);
    %Change between normalized and pixels
    %text(0.5,0.5,'Welcome to OpenNanopore! ','Color','white','Units','normalized','BackgroundColor','blue', 'Fontsize',20,'HorizontalAlignment','center')
text(pos(3)/2,pos(4)/2,'OpenNanopore - Statistics! ','Color','white','Units','pixels','BackgroundColor','blue', 'FontUnits','pixels','Fontsize',40,'HorizontalAlignment','center')
set(gca,'XTick',[],'YTick',[])
    
%% HistoBottom    
axes(handles.histodwell)
pos=get(handles.histodwell,'Position');
cla
image(epfl)
set(gca,'XTick',[],'YTick',[])
%plot(sin(linspace(-2*pi,2*pi,1000)),'LineWidth',5);
%Change between normalized and pixels
%text(0.5,0.5,'Welcome to OpenNanopore! ','Color','white','Units','normalized','BackgroundColor','blue', 'Fontsize',20,'HorizontalAlignment','center')
%text(pos(3)/2,pos(4)/2,'Open a database to begin...','Color','white','Units','pixels','BackgroundColor','blue', 'FontUnits','pixels','Fontsize',20,'HorizontalAlignment','center')
    
%% Histo Left
epflRot=importdata(['Scripts' f 'EPFLRot.png']);
axes(handles.histocurrent)
cla
image(epflRot)
set(gca,'XTick',[],'YTick',[])


%% Initialize all the colors
up = imread('Scripts/arrowUP.BMP');
set(handles.Up,'Cdata',up);

down = imread('Scripts/ArrowDOWN.BMP');
set(handles.down,'Cdata',down);

s=get(handles.yellow,'Position');
set(handles.yellow,'CData',mkcolor(1,1,0,s(3:4)))

s=get(handles.magenta,'Position');
set(handles.magenta,'CData',mkcolor(1,0,1,s(3:4)))

s=get(handles.cyan,'Position');
set(handles.cyan,'CData',mkcolor(0,1,1,s(3:4)))

s=get(handles.red,'Position');
set(handles.red,'CData',mkcolor(1,0,0,s(3:4)))

s=get(handles.green,'Position');
set(handles.green,'CData',mkcolor(0,1,0,s(3:4)))

s=get(handles.blue,'Position');
set(handles.blue,'CData',mkcolor(0,0,1,s(3:4)))

s=get(handles.black,'Position');
set(handles.black,'CData',mkcolor(0,0,0,s(3:4)))

set(handles.editR,'String',1)
set(handles.editG,'String',1)
set(handles.editB,'String',1)
%Load_Callback(hObject, eventdata, handles)
checkboxLevel_Callback(hObject, eventdata, handles)


% UIWAIT makes GUI_Statistics wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = GUI_Statistics_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
%varargout{1} = handles.output;


% --- Executes on button press in Load.
function Load_Callback(hObject, eventdata, handles)
% hObject    handle to Load (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% ExperimentTitle='Results_from_analysis';
%chosen='ExperimentData.mat';
% a=load([ExperimentTitle filesep chosen]);
[FileName,PathName,FilterIndex] = uigetfile('*.mat');
a=load([PathName FileName]);
if(isfield(a, 'EventDatabase'))
temp.ExperimentTitle=PathName;
temp.MatFile=FileName;
temp.EventDatabase=a.EventDatabase;
temp.ConcatenatedEvents=a.ConcatenatedEvents;
temp.ConcatenatedFits=a.ConcatenatedFits;
%temp.filtered=FilterEvents(a.EventDatabase);
temp.time_units=a.time_units;
temp.SamplingFrequency=a.SamplingFrequency;
temp.current_units=a.current_units;
handles.DBList=[handles.DBList temp];
guidata(hObject, handles);
set(handles.listbox2,'String',{handles.DBList.MatFile});
%guidata(hObject, handles);
%draw(hObject, eventdata, handles)
else
    errordlg('The specified .mat file does not contain an event database','Error')
end


function draw(hObject, eventdata, handles)
%% Determine Units
units=1e3;
switch handles.DBList(1).time_units
    case 'us' 
        units=1e6;
    case 'ms' 
        units=1e3;
    case 's' 
        units=1;
end


%% Scatter


cla(handles.scatter)
cla(handles.histocurrent)
cla(handles.histodwell)
cla(handles.event)

list=handles.list;
handles.x_time=struct;
handles.currents=struct;

max_current=-Inf;
min_current=Inf;
max_dwell=-Inf;
min_dwell=Inf;
max_counts_current=-Inf;
max_counts_dwell=-Inf;

for i=1:length(list)
db_in=list(i).chosen_DB;

events=handles.DBList(db_in).EventDatabase;
L=EventDB2LTable(events);
SamplingFrequency=handles.DBList(db_in).SamplingFrequency;
x_time=L(:,5)./SamplingFrequency.*units;

handles.x_time.(['DB' int2str(i)])=x_time(list(i).IndexesL);
handles.currents.(['DB' int2str(i)])=L(list(i).IndexesL,6);
guidata(hObject, handles);


%% Axis Calculation
if(max(L(list(i).IndexesL,6))>max_current)
    max_current=max(L(list(i).IndexesL,6));
end
if(min(L(list(i).IndexesL,6))<min_current)
    min_current=min(L(list(i).IndexesL,6));
end
if(min(x_time(list(i).IndexesL))<min_dwell)
    min_dwell=min(x_time(list(i).IndexesL));
end
if(max(x_time(list(i).IndexesL))>max_dwell)
    max_dwell=max(x_time(list(i).IndexesL));
end
    
    
%axes(handles.scatter);  
    %hold on;
    legend(handles.scatter,'off')
    scatter(handles.scatter,x_time(list(i).IndexesL), L(list(i).IndexesL,6),'Marker','o','MarkerFaceColor',list(i).Color,'MarkerEdgeColor',list(i).Color);
    %set(0,'ShowHiddenHandles','on')
    %childHandle = get(h,'Children');
    %set(childHandle,'MarkerFaceAlpha',0.5)
    hold(handles.scatter,'on');

%% Current Histogram

%binsize=str2double(get(handles.bin,'String'));
%axes(handles.histocurrent);

legend(handles.histocurrent,'off')
nbins=get(handles.sliderbin,'Value');

%hold on;
[counts,bins]=hist(L(list(i).IndexesL,6),nbins);
if(max(counts)>max_counts_current)
    max_counts_current=max(counts);
end
h=barh(handles.histocurrent,bins,counts,'FaceColor',list(i).Color,'EdgeColor',list(i).Color,'BarWidth',1);
childHandle = get(h,'Children');
set(childHandle,'FaceAlpha',0.5); % 0 = transparent, 1 = opaque.
set(childHandle,'EdgeAlpha',0.5);
hold(handles.histocurrent,'on');
axis(handles.histocurrent,[0, max_counts_current,min_current, max_current])
grid(handles.histocurrent,'on');
ylabel(handles.histocurrent,['Current Blockage [' handles.DBList(1).current_units ']'])
xlabel(handles.histocurrent,'Counts')

%% Dwell Time Histogram
%axes(handles.histodwell);
legend(handles.histodwell,'off')

%hold on;
[counts,bins]=hist(handles.histodwell,L(list(i).IndexesL,5)./SamplingFrequency.*units,nbins);
if(max(counts)>max_counts_dwell)
    max_counts_dwell=max(counts);
end
h=bar(handles.histodwell,bins,counts,'FaceColor',list(i).Color,'EdgeColor',list(i).Color,'BarWidth',1);
childHandle = get(h,'Children');
set(childHandle,'FaceAlpha',0.5); % 0 = transparent, 1 = opaque.
set(childHandle,'EdgeAlpha',0.5)
set(childHandle,'EdgeLighting','gouraud')
axis(handles.histodwell,[min_dwell, max_dwell, 0, max_counts_dwell])
hold(handles.histodwell,'on');

%hist(L(:,5)./SamplingFrequency.*units,nbins);
grid(handles.histodwell,'on')
xlabel(handles.histodwell,['Dwell Time [' handles.DBList(1).time_units ']'])
ylabel(handles.histodwell,'Counts')
end
%display(handles.x_time)

%Select Event
if(isfield(handles,'selected_index'))
    selected_index=handles.selected_index;
else
    selected_index=1;
end
%axes(handles.scatter);

events=handles.DBList(handles.selected_index_DB).EventDatabase;
L=EventDB2LTable(events);
SamplingFrequency=handles.DBList(handles.selected_index_DB).SamplingFrequency;
x_time=L(:,5)./SamplingFrequency.*units;
if(isfield(handles.currents,['DB' int2str(handles.selecTHING)]))
if(~isempty(handles.currents.(['DB' int2str(handles.selecTHING)])))
selected_index=find(L(:,6)==handles.currents.(['DB' int2str(handles.selecTHING)])(selected_index));
else
    selected_index=1;
end
else
        selected_index=1;
end
selected_event=L(selected_index(1),1);
handles.current_event=selected_event;

if(events(selected_event).NumberOfLevels>1)
    indices=find(L(:,1)==selected_event);
    %hold on;
    scatter(handles.scatter,x_time(indices),L(indices,6),'o','y','SizeData',100,'LineWidth',2.5);  
end

%hold on;
scatter(handles.scatter,x_time(selected_index),L((selected_index),6),'o','r','SizeData',100,'LineWidth',2.5)
grid(handles.scatter,'on')
axis(handles.scatter,[min_dwell, max_dwell, min_current, max_current])
xlabel(handles.scatter,['Dwell time [' handles.DBList(1).time_units ']'])
ylabel(handles.scatter,['Current blockage [' handles.DBList(1).current_units ']'])


%% Event Display
db_in=handles.selected_index_DB;
events=handles.DBList(db_in).EventDatabase;
ConcatenatedEvents=handles.DBList(db_in).ConcatenatedEvents;
ConcatenatedFits=handles.DBList(db_in).ConcatenatedFits;
i=handles.current_event;
%axes(handles.event);
%cla
zoom('out')
startp=events(i).ConcatenatedStartCoordinates-50+1;
endp=events(i).ConcatenatedStartCoordinates+length(events(i).AllLevelFits)-1+50;
xbase=1:(endp-startp+1);
normal=events(i).Levels(1,4)-events(i).ConcatenatedStartCoordinates;
star=events(i).Levels(L(selected_index,2),4)-normal+3;
en=events(i).Levels(L(selected_index,2),5)-normal+1;
%lenth=events(i).Levels(L(selected_index,6))
x1=xbase./SamplingFrequency.*units;
x2=xbase(star-startp:en-startp)./SamplingFrequency.*units;
plot(handles.event,x1,ConcatenatedEvents(startp:endp),'b','Linewidth',1.5);
hold(handles.event,'on')
plot(handles.event,x1,ConcatenatedFits(startp:endp),'y','Linewidth',1.5);
hold(handles.event,'on')
plot(handles.event,x2,ConcatenatedFits(star:en),'r','Linewidth',1.5);

%axis equal
grid(handles.event,'on');
xlabel(handles.event,['Time [' handles.DBList(1).time_units ']'])
ylabel(handles.event,['Current [' handles.DBList(1).current_units ']'])
set(handles.uipanel1,'Title', ['Scatter Plot and Histograms, Event ' int2str(i) ' from database ' handles.DBList(db_in).MatFile  ' is selected.']);


% --- Executes on mouse press over figure background, over a disabled or
% --- inactive control, or over an axes background.
function figure1_WindowButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% handles    structure with handles and user data (see GUIDATA)
pos=get(hObject,'CurrentPoint');
panelpos=get(handles.uipanel1,'Position');
axes(handles.scatter)
plotpos=get(gca,'Position');
x=pos(1);
y=pos(2);
xleft=panelpos(1)+plotpos(1);
xrigth=xleft+plotpos(3);
ydown=panelpos(2)+plotpos(2);
yup=ydown+plotpos(4);
if(x<xrigth && x>xleft && y<yup && y>ydown && ~isempty(handles.list))
pt=get(gca,'CurrentPoint');

ind=[];
dist=[];
for i=1:length(handles.list)
[inde d]=knnsearch([handles.x_time.(['DB' int2str(i)]) handles.currents.(['DB' int2str(i)])],[pt(1,1) pt(1,2)]);
ind=[ind inde];
dist=[dist d];
end

[a v]=min(dist);

ind=ind(v);
handles.selected_index_DB=handles.list(v).chosen_DB;
handles.selecTHING=v;
handles.selected_index=ind;

guidata(hObject, handles);
draw(hObject, eventdata, handles)
end


% --- Executes on slider movement.
function sliderbin_Callback(hObject, eventdata, handles)
% hObject    handle to sliderbin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.bintext,'String',[num2str(get(hObject,'Value')) ' bins'])
if(~isempty(handles.list))
draw(hObject, eventdata, handles)
end

% --- Executes during object creation, after setting all properties.
function sliderbin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sliderbin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end



function editR_Callback(hObject, eventdata, handles)
% hObject    handle to editR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editR as text
%        str2double(get(hObject,'String')) returns contents of editR as a double
currentcolor_Callback(hObject, eventdata, handles)


% --- Executes during object creation, after setting all properties.
function editR_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editG_Callback(hObject, eventdata, handles)
% hObject    handle to editG (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editG as text
%        str2double(get(hObject,'String')) returns contents of editG as a double
currentcolor_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function editG_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editG (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function editB_Callback(hObject, eventdata, handles)
% hObject    handle to editB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editB as text
%        str2double(get(hObject,'String')) returns contents of editB as a double
currentcolor_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function editB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in yellow.
function yellow_Callback(hObject, eventdata, handles)
% hObject    handle to yellow (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dat=get(hObject,'CData');
set(handles.editR,'String',num2str(dat(1,1,1)))
set(handles.editG,'String',num2str(dat(1,1,2)))
set(handles.editB,'String',num2str(dat(1,1,3)))
currentcolor_Callback(hObject, eventdata, handles)


% --- Executes on button press in magenta.
function magenta_Callback(hObject, eventdata, handles)
% hObject    handle to magenta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dat=get(hObject,'CData');
set(handles.editR,'String',num2str(dat(1,1,1)))
set(handles.editG,'String',num2str(dat(1,1,2)))
set(handles.editB,'String',num2str(dat(1,1,3)))
currentcolor_Callback(hObject, eventdata, handles)

% --- Executes on button press in cyan.
function cyan_Callback(hObject, eventdata, handles)
% hObject    handle to cyan (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dat=get(hObject,'CData');
set(handles.editR,'String',num2str(dat(1,1,1)))
set(handles.editG,'String',num2str(dat(1,1,2)))
set(handles.editB,'String',num2str(dat(1,1,3)))
currentcolor_Callback(hObject, eventdata, handles)

% --- Executes on button press in red.
function red_Callback(hObject, eventdata, handles)
% hObject    handle to red (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dat=get(hObject,'CData');
set(handles.editR,'String',num2str(dat(1,1,1)))
set(handles.editG,'String',num2str(dat(1,1,2)))
set(handles.editB,'String',num2str(dat(1,1,3)))
currentcolor_Callback(hObject, eventdata, handles)

% --- Executes on button press in green.
function green_Callback(hObject, eventdata, handles)
% hObject    handle to green (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dat=get(hObject,'CData');
set(handles.editR,'String',num2str(dat(1,1,1)))
set(handles.editG,'String',num2str(dat(1,1,2)))
set(handles.editB,'String',num2str(dat(1,1,3)))
currentcolor_Callback(hObject, eventdata, handles)

% --- Executes on button press in blue.
function blue_Callback(hObject, eventdata, handles)
% hObject    handle to blue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dat=get(hObject,'CData');
set(handles.editR,'String',num2str(dat(1,1,1)))
set(handles.editG,'String',num2str(dat(1,1,2)))
set(handles.editB,'String',num2str(dat(1,1,3)))
currentcolor_Callback(hObject, eventdata, handles)

% --- Executes on button press in black.
function black_Callback(hObject, eventdata, handles)
% hObject    handle to black (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
dat=get(hObject,'CData');
set(handles.editR,'String',num2str(dat(1,1,1)))
set(handles.editG,'String',num2str(dat(1,1,2)))
set(handles.editB,'String',num2str(dat(1,1,3)))
currentcolor_Callback(hObject, eventdata, handles)


% --- Executes on button press in currentcolor.
function currentcolor_Callback(hObject, eventdata, handles)
% hObject    handle to currentcolor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
r=str2num(get(handles.editR,'String'));
g=str2num(get(handles.editG,'String'));
b=str2num(get(handles.editB,'String'));
s=get(handles.currentcolor,'Position');
set(handles.currentcolor,'CData',mkcolor(r,g,b,s(3:4)))
handles.current_color=[r g b];
guidata(hObject, handles)

function levelLimitMin_Callback(hObject, eventdata, handles)
% hObject    handle to levelLimitMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of levelLimitMin as text
%        str2double(get(hObject,'String')) returns contents of levelLimitMin as a double
handles.levelLimitMinVal=str2double(get(hObject,'String'));
guidata(hObject, handles)

% --- Executes during object creation, after setting all properties.
function levelLimitMin_CreateFcn(hObject, eventdata, handles)
% hObject    handle to levelLimitMin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in addFilter.
function addFilter_Callback(hObject, eventdata, handles)
% hObject    handle to addFilter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(~isempty(handles.DBList))
filtering(hObject, eventdata, handles)
end

% --- Executes on selection change in listbox1.
function listbox1_Callback(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox1
%set( h, 'String', {'<html><b>a</b></html>', 'b'} )
%display(length(handles.list))
if(~isempty(handles.list))
set(handles.listbox1,'String',{handles.list(:).Name});
draw(hObject, eventdata, handles)
else
    set(handles.listbox1,'String',{'No Filter Settings chosen...'})
cla(handles.scatter)
cla(handles.histocurrent)
cla(handles.histodwell)
cla(handles.event)
end

% --- Executes during object creation, after setting all properties.
function listbox1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function filtering(hObject, eventdata, handles)

%% Level Limit Filter
if(get(handles.checkboxLevel,'Value'))
limitMin=str2double(get(handles.levelLimitMin,'String'));
limitMax=str2double(get(handles.levelLimitMax,'String'));
else
    limitMin=-Inf;
    limitMax=Inf;
end

standardEV=get(handles.standardevents,'Value');
impulsionEV=get(handles.impulsions,'Value');

chosen_DB=get(handles.listbox2,'Value');
events=handles.DBList(chosen_DB).EventDatabase;


ind=[];
s='';

if(standardEV && impulsionEV)
    s='Standard Events & Impulsions';
for i=1:length(events)
    if((strcmp(events(i).EventType,'Standard Event') || strcmp(events(i).EventType,'Impulsion')) && events(i).NumberOfLevels>=limitMin && events(i).NumberOfLevels<=limitMax)
        ind=[ind i];
    end
end
end
if(standardEV && ~impulsionEV)
    s='Standard Events';
for i=1:length(events)
    if((strcmp(events(i).EventType,'Standard Event')) && events(i).NumberOfLevels>=limitMin && events(i).NumberOfLevels<=limitMax)
        ind=[ind i];
    end
end
end

if(~standardEV && impulsionEV)
    s='Impulsions';
for i=1:length(events)
    if((strcmp(events(i).EventType,'Impulsion')) && events(i).NumberOfLevels>=limitMin && events(i).NumberOfLevels<=limitMax)
        ind=[ind i];
    end
end
end

if(~standardEV && ~impulsionEV)
    s='Standard Events & Impulsions';
for i=1:length(events)
    if(events(i).NumberOfLevels>=limitMin && events(i).NumberOfLevels<=limitMax)
        ind=[ind i];
    end
end
end

%% Save to list
r=str2num(get(handles.editR,'String'));
g=str2num(get(handles.editG,'String'));
b=str2num(get(handles.editB,'String'));

L=EventDB2LTable(events);
indL=[];
for i=1:length(ind)
indL=[indL;find(L(:,1)==ind(i))];
end

a=struct;
s3=[handles.DBList(chosen_DB).MatFile ': '];
s1=['<b>' s3 s ': ' num2str(limitMin) '-' num2str(limitMax) '</b>'];
s2=['<html><<FONT COLOR="rgb(' num2str(255*r) ',' num2str(255*g) ',' num2str(255*b) ')">' s1 '</FONT></html>'];
a.Indexes=ind;
a.IndexesL=indL;
a.Name=s2;
a.chosen_DB=chosen_DB;
a.Color=[r g b];
if(~isempty(ind))
list=handles.list;
list=[list a];
handles.list=list;
guidata(hObject, handles)
listbox1_Callback(hObject, eventdata, handles)
else
    errordlg('No events are found using the provided settings. Please change the filter settings','Error')
    return
end

function levelLimitMax_Callback(hObject, eventdata, handles)
% hObject    handle to levelLimitMax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of levelLimitMax as text
%        str2double(get(hObject,'String')) returns contents of levelLimitMax as a double
handles.levelLimitMaxVal=str2double(get(hObject,'String'));
guidata(hObject, handles)


% --- Executes during object creation, after setting all properties.
function levelLimitMax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to levelLimitMax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkboxLevel.
function checkboxLevel_Callback(hObject, eventdata, handles)
% hObject    handle to checkboxLevel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkboxLevel
if(get(handles.checkboxLevel,'Value'))
set(handles.text8,'Enable','on')
set(handles.text7,'Enable','on')
set(handles.text9,'Enable','on') 
set(handles.levelLimitMin,'Enable','on')
set(handles.levelLimitMax,'Enable','on')
else
set(handles.text8,'Enable','off')
set(handles.text7,'Enable','off')
set(handles.text9,'Enable','off') 
set(handles.levelLimitMin,'Enable','off')
set(handles.levelLimitMax,'Enable','off')
end

% --- Executes on button press in standardevents.
function standardevents_Callback(hObject, eventdata, handles)
% hObject    handle to standardevents (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of standardevents


% --- Executes on button press in impulsions.
function impulsions_Callback(hObject, eventdata, handles)
% hObject    handle to impulsions (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of impulsions


% --- Executes on key press with focus on figure1 or any of its controls.
function figure1_WindowKeyPressFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  structure with the following fields (see FIGURE)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
a=eventdata.Key;
% if(strcmp(a,'backspace') && ~isempty(handles.list))
% ind=get(handles.listbox1,'Value');
% if(ind>0)
%     if(ind==length(handles.list))
%     set(handles.listbox1,'Value',ind-1)
%     end
%     if(ind==1)
%     set(handles.listbox1,'Value',1)
%     end
% %handles.DBList(handles.list(ind).chosen_DB)=[];
% handles.list(ind)=[];
% guidata(hObject,handles)
% end
% 
% listbox1_Callback(hObject, eventdata, handles)    
% end

if(strcmp(a,'return') && ~isempty(handles.list))
draw(hObject, eventdata, handles)
end


% --------------------------------------------------------------------
function uipushtool1_ClickedCallback(hObject, eventdata, handles)
% hObject    handle to uipushtool1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Load_Callback(hObject, eventdata, handles)


% --- Executes on button press in Up.
function Up_Callback(hObject, eventdata, handles)
% hObject    handle to Up (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ind=get(handles.listbox1,'Value');
%handles.list=get(handles.listbox1,'String')

if(ind>1)
for i=1:ind-2
texnew(i)=handles.list(i);   
end
texnew(ind-1)=handles.list(ind);
texnew(ind)=handles.list(ind-1);
for i=ind+1:length(handles.list)
texnew(i)=handles.list(i);   
end
handles.list=texnew;
handles.selected_index=1;
guidata(hObject,handles)
set(handles.listbox1, 'Value',ind-1)
listbox1_Callback(hObject, eventdata, handles)
end

% --- Executes on button press in down.
function down_Callback(hObject, eventdata, handles)
% hObject    handle to down (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ind=get(handles.listbox1,'Value');
%handles.list=get(handles.listbox1,'String')

if(ind<length(handles.list))
for i=1:ind-1
texnew(i)=handles.list(i);   
end
texnew(ind)=handles.list(ind+1);
texnew(ind+1)=handles.list(ind);
for i=ind+2:length(handles.list)
texnew(i)=handles.list(i);   
end
handles.list=texnew;
handles.selected_index=1;
guidata(hObject,handles)
set(handles.listbox1, 'Value',ind+1)
listbox1_Callback(hObject, eventdata, handles)
end


% --------------------------------------------------------------------
function uipushtool2_ClickedCallback(hObject, eventdata, handles)
% hObject    handle to uipushtool2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%%SAVE PLOTS
%axes(handles.scatter)
%close(h)
panelpos=get(handles.uipanel1,'Position');
%formats={'ai','bmp','emf','eps','fig','jpg','m','pbm','pcx','pdf','pgm','png','ppm','tif','tiffn'};

%set(0,'showhiddenhandles','on'); % Make the GUI figure handle visible
%h = findobj(gcf,'type','axes'); % Find the axes object in the GUI
h=figure('Position',panelpos); % Create a new figure
%copyobj(h,f1); % Copy axes object h into figure f1
copyobj(handles.scatter,h)
copyobj(handles.histodwell,h)
copyobj(handles.histocurrent,h)
copyobj(handles.event,h)



% f=filesep;
% path=handles.ExperimentTitle;
% export_fig(handles.scatter, [path f 'GUI_Event']);
% export_fig(handles.histodwell,[path f 'GUI_Concatenated']);


% --- Executes on selection change in listbox2.
function listbox2_Callback(hObject, eventdata, handles)
% hObject    handle to listbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox2


% --- Executes during object creation, after setting all properties.
function listbox2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in deletelist.
function deletelist_Callback(hObject, eventdata, handles)
% hObject    handle to deletelist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(~isempty(handles.list))
ind=get(handles.listbox1,'Value');
if(ind>0)
    if(ind==length(handles.list))
    set(handles.listbox1,'Value',ind-1)
    end
    if(ind==1)
    set(handles.listbox1,'Value',1)
    end
handles.currents=rmfield(handles.currents,['DB' int2str(ind)]);
handles.list(ind)=[];
handles.selected_index=1;
guidata(hObject,handles)
end

listbox1_Callback(hObject, eventdata, handles)    
end


% --- Executes on button press in pushbutton14.
function pushbutton14_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Load_Callback(hObject, eventdata,handles);
