function varargout = GUI_Analysis(varargin)
% GUI_Analysis MATLAB code for GUI_Analysis.fig
%      GUI_Analysis, by itself, creates a new GUI_Analysis or raises the existing
%      singleton*.
%
%      H = GUI_Analysis returns the handle to a new GUI_Analysis or the handle to
%      the existing singleton*.
%
%      GUI_Analysis('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GUI_Analysis.M with the given input arguments.
%
%      GUI_Analysis('Property','Value',...) creates a new GUI_Analysis or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI_Analysis before GUI_Analysis_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to GUI_Analysis_OpeningFcn via varargin.
%
%      *See GUI_Analysis Options on GUIDE's Tools menu.  Choose "GUI_Analysis allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help GUI_Analysis

% Last Modified by GUIDE v2.5 02-Aug-2012 10:54:46

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @GUI_Analysis_OpeningFcn, ...
                   'gui_OutputFcn',  @GUI_Analysis_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before GUI_Analysis is made visible.
function GUI_Analysis_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GUI_Analysis (see VARARGIN)
% Choose default command line output for GUI_Analysis
set(hObject, 'Name', 'OpenNanopore-Analysis')
handles.output = hObject;
handles.flagAnalysisDone=0;
handles.time_units='ms';
handles.current_units='nA';
% Update handles structure
guidata(hObject, handles);
f=filesep;
p=mfilename('fullpath');
direct=fileparts(p);
addpath([direct f 'Scripts']);
% This sets up the initial plot - only do when we are invisible
% so window can get raised using GUI_Analysis.
epfl=importdata(['Scripts' f 'EPFL.png']);
if strcmp(get(hObject,'Visible'),'off')
    %logo axes
    axes(handles.axes5)
    cla
    image(epfl);
    set(gca,'XTick',[],'YTick',[])
    %lower axes
    axes(handles.PlotWindow)
    cla
    plot(sin(linspace(-2*pi,2*pi,1000)));
    %Change between normalized and pixels
    %text(0.5,0.5,'Welcome to OpenNanopore! ','Color','white','Units','normalized','BackgroundColor','blue', 'Fontsize',20,'HorizontalAlignment','center')
    text(128,83,'Welcome to OpenNanopore! ','Color','white','Units','pixels','BackgroundColor','blue', 'FontUnits','pixels','Fontsize',20,'HorizontalAlignment','center')
    xlabel(['Time [' handles.time_units ']'])
    ylabel(['Current [' handles.current_units ']'])
    %upper axes
    axes(handles.PlotWindow2)
    cla
    plotbatmaneq;
    xlabel(['Time [' handles.time_units ']'])
    ylabel(['Current [' handles.current_units ']'])
end
editExperimentTitle_Callback(hObject, eventdata, handles)


% UIWAIT makes GUI_Analysis wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = GUI_Analysis_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

f=filesep;
i=str2double(get(handles.entereventnumber,'String'));

event=handles.EventDatabase;
if(i>length(event))
    i=1;
    set(handles.entereventnumber,'String', int2str(i));
end
if(i<1)
    i=length(event);
    set(handles.entereventnumber,'String', int2str(i));
end

if(event(i).NumberOfLevels==1)
ending='';
else
    ending='s';
end

text2=sprintf('The area of the event is: %1.3e C.\n\n', event(i).AreaCoulomb);
text=sprintf('The current event contains %i level%s. \n%s%s',event(i).NumberOfLevels,ending,text2, Level2String(event(i).Levels,str2num(get(handles.edit6,'String'))*1000,handles.time_units,handles.current_units)); 
set(handles.EventInfos,'String', text);
handles.numberofevents=length(event);
guidata(hObject, handles);

%% Concatenated
ConcatenatedEvents=handles.ConcatenatedEvents;
ConcatenatedFits=handles.ConcatenatedFits;

axes(handles.PlotWindow2);
cla
zoom('out')
start=event(i).ConcatenatedStartCoordinates;
endp=start+event(i).StartAndEndPoint(2)-event(i).StartAndEndPoint(1);
units=1e3;
switch handles.time_units
    case 'us' 
        units=1e6;
    case 'ms' 
        units=1e3;
    case 's' 
        units=1;
end

%start=start./(str2num(get(handles.edit6,'String'))*1000)*units;
%endp=endp./(str2num(get(handles.edit6,'String'))*1000)*units;

x=1:length(ConcatenatedEvents); x=x./(str2num(get(handles.edit6,'String'))*1000).*units;
plot(x,ConcatenatedEvents,'b')
hold on
b=10./(str2num(get(handles.edit6,'String'))*1000).*units;
rectangle('Position',[x(start)-b,min(ConcatenatedEvents(start:endp)),x(endp)-x(start)+b+10/(str2num(get(handles.edit6,'String'))*1000).*units,max(ConcatenatedEvents(start-40:endp+40))+abs(min(ConcatenatedEvents(start:endp)))],'EdgeColor','r', 'LineWidth',2)

%rectangle('Position',[start-10,min(concEv.ConcatenatedEvents(start:endp)),endp-start+10,max(concEv.ConcatenatedEvents(start-40:endp+40))+abs(min(concEv.ConcatenatedEvents(start:endp)))],'EdgeColor','r', 'LineWidth',2)
grid on;
    xlabel(['Time [' handles.time_units ']'])
    ylabel(['Current [' handles.current_units ']'])
    set(handles.uipanel8,'Title', 'Concatenated Events');

%%  Event
axes(handles.PlotWindow);
cla
zoom('out')
startp=handles.EventDatabase(i).ConcatenatedStartCoordinates-50+1;
endp=handles.EventDatabase(i).ConcatenatedStartCoordinates+length(handles.EventDatabase(i).AllLevelFits)-1+50;
xbase=1:(endp-startp+1);
x1=xbase./(str2num(get(handles.edit6,'String')).*1000).*units;
x2=xbase./(str2num(get(handles.edit6,'String')).*1000).*units;
plot(x1,ConcatenatedEvents(startp:endp),'b','Linewidth',1.5);
hold on
plot(x2,ConcatenatedFits(startp:endp),'r','Linewidth',1.5);
%axis equal
grid on;
    xlabel(['Time [' handles.time_units ']'])
    ylabel(['Current [' handles.current_units ']'])
    set(handles.uipanel9,'Title', ['Event ' int2str(i)]);

set(handles.text2, 'String',[get(handles.entereventnumber,'String') '/' int2str(handles.numberofevents)]);




% --------------------------------------------------------------------
function FileMenu_Callback(hObject, eventdata, handles)
% hObject    handle to FileMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function OpenMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to OpenMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
file = uigetfile('*.fig');
if ~isequal(file, 0)
    open(file);
end

% --------------------------------------------------------------------
function PrintMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to PrintMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
printdlg(handles.figure1)

% --------------------------------------------------------------------
function CloseMenuItem_Callback(hObject, eventdata, handles)
% hObject    handle to CloseMenuItem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
selection = questdlg(['Close ' get(handles.figure1,'Name') '?'],...
                     ['Close ' get(handles.figure1,'Name') '...'],...
                     'Yes','No','Yes');
if strcmp(selection,'No')
    return;
end

delete(handles.figure1)


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
     set(hObject,'BackgroundColor','white');
end

set(hObject, 'String', {'plot(rand(5))', 'plot(sin(1:0.01:25))', 'bar(1:.5:10)', 'plot(membrane)', 'surf(peaks)'});


% --- Executes on button press in pushbuttonPrevious.
function pushbuttonPrevious_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonPrevious (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isdir(get(handles.editExperimentTitle,'String')))
current=str2double(get(handles.entereventnumber,'String'));
set(handles.entereventnumber,'String', int2str(current-1));
pushbutton1_Callback(hObject, eventdata, handles);
else
     msgbox(['The folder: ' get(handles.editExperimentTitle,'String') ' does not exist. Please perform an analysis before using the browser.'] ,'Info','error');
end

% --- Executes on button press in pushbuttonNext.
function pushbuttonNext_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonNext (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isdir(get(handles.editExperimentTitle,'String')))
current=str2double(get(handles.entereventnumber,'String'));
set(handles.entereventnumber,'String', int2str(current+1));
pushbutton1_Callback(hObject, eventdata, handles);
else
     msgbox(['The folder: ' get(handles.editExperimentTitle,'String') ' does not exist. Please perform an analysis before using the browser.'] ,'Info','error');
end


function entereventnumber_Callback(hObject, eventdata, handles)
% hObject    handle to entereventnumber (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of entereventnumber as text
%        str2double(get(hObject,'String')) returns contents of entereventnumber as a double
user_entry = str2double(get(hObject,'string'));
if isnan(user_entry)
  errordlg('You must enter a numeric value','Bad Input','modal')
  uicontrol(hObject)
	return
end

if(isdir(get(handles.editExperimentTitle,'String')))
pushbutton1_Callback(hObject, eventdata, handles);
else
     msgbox(['The folder: ' get(handles.editExperimentTitle,'String') ' does not exist. Please perform an analysis before using the browser.'] ,'Info','error');
end

% --- Executes during object creation, after setting all properties.
function entereventnumber_CreateFcn(hObject, eventdata, handles)
% hObject    handle to entereventnumber (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbuttonAnalysis.
function pushbuttonAnalysis_Callback(hObject, eventdata, handles)
% hObject    handle to pushbuttonAnalysis (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
ExperimentTitle=get(handles.editExperimentTitle,'String');
[FileName,PathName,~]=uigetfile('*.mat','Select mat file containing the signal');
if FileName==0, return, end
handles.filepath=[PathName FileName];
guidata(hObject, handles);
output=open([PathName FileName]);
structure=fieldnames(output);
set(handles.variableChooser,'String', structure);
variableChooser_Callback(hObject, eventdata, handles);

function editExperimentTitle_Callback(hObject, eventdata, handles)
% hObject    handle to editExperimentTitle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editExperimentTitle as text
%        str2double(get(hObject,'String')) returns contents of editExperimentTitle as a double
%% Open EventDB
ExperimentTitle=get(handles.editExperimentTitle,'String');
handles.ExperimentTitle=ExperimentTitle;
guidata(hObject, handles);
if(isdir(ExperimentTitle))
temp = what(ExperimentTitle);
set(handles.DBselect,'String', temp.mat);
DBselect_Callback(hObject, eventdata, handles)
else
    set(handles.DBselect,'String', 'New Analysis');
end


% --- Executes during object creation, after setting all properties.
function editExperimentTitle_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editExperimentTitle (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in variableChooser.
function variableChooser_Callback(hObject, eventdata, handles)
% hObject    handle to variableChooser (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns variableChooser contents as cell array
%        contents{get(hObject,'Value')} returns selected item from variableChooser
axes(handles.PlotWindow2)
cla
zoom('out')
contents = cellstr(get(handles.variableChooser,'String'));
variable=contents{get(handles.variableChooser,'Value')};
output=open(handles.filepath);
RawSignal=getfield(output,variable);
units=1e3;
switch handles.time_units
    case 'us' 
        units=1e6;
    case 'ms' 
        units=1e3;
    case 's' 
        units=1;
end
x=1:length(RawSignal); x=x./(str2num(get(handles.edit6,'String'))*1000).*units;

plot(x,RawSignal)
    xlabel(['Time [' handles.time_units ']'])
    ylabel(['Current [' handles.current_units ']'])
    set(handles.uipanel8,'Title', 'Input Signal');
s=sprintf('Length of signal:\t\t%i samples\nMean:\t\t\t%1.1e %s\nStandard Deviation:\t\t%1.1e %s\nMinimal value:\t\t%1.3f %s\nMaximal Value:\t\t%1.3f %s\n',length(RawSignal),mean(RawSignal),handles.current_units, std(RawSignal),handles.current_units, min(RawSignal),handles.current_units, max(RawSignal),handles.current_units);
set(handles.EventInfos,'String',s);
%set(handles.editSigma,'String',num2str(std(RawSignal)));    

% --- Executes during object creation, after setting all properties.
function variableChooser_CreateFcn(hObject, eventdata, handles)
% hObject    handle to variableChooser (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in StartAnalysis.
function StartAnalysis_Callback(hObject, eventdata, handles)
% hObject    handle to StartAnalysis (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
contents = cellstr(get(handles.variableChooser,'String'));
variable=contents{get(handles.variableChooser,'Value')};
output=open(handles.filepath);
RawSignal=getfield(output,variable);
ExperimentTitle=get(handles.editExperimentTitle,'String');
delta=str2num(get(handles.FieldDelta,'String'));
sigma=str2num(get(handles.editSigma,'String'));
SamplingFrequency=str2num(get(handles.edit6,'String'))*1000;
time_units=handles.time_units;      
current_units=handles.current_units;         
main_for_gui
%%  IntroText
str2=AnalysisInfos(EventDatabase);
handles.introText=[outputstring str2];
handles.flagAnalysisDone=1;
guidata(hObject, handles);
set(handles.entereventnumber,'String', int2str(1));
pushbutton9_Callback(hObject, eventdata, handles);
out=fopen([get(handles.editExperimentTitle,'String') filesep 'Global_Informations.txt'],'w');
fprintf(out,'%s',handles.introText);
fclose(out);
editExperimentTitle_Callback(hObject, eventdata, handles)
DetectedEvents_Callback(hObject, eventdata, handles);
set(handles.detectedeventsvisible,'Value',1)
detectedeventsvisible_Callback(hObject,eventdata,handles)

% --- Executes during object creation, after setting all properties.
function PlotWindow2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to PlotWindow2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate PlotWindow2



function FieldDelta_Callback(hObject, eventdata, handles)
% hObject    handle to FieldDelta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of FieldDelta as text
%        str2double(get(hObject,'String')) returns contents of FieldDelta as a double
user_entry = str2double(get(hObject,'string'));
if isnan(user_entry) || user_entry<0
  msgbox('You must enter a POSITIVE numeric value','Bad Input','error')
  set(hObject,'string',num2str(abs(user_entry)));
end

% --- Executes during object creation, after setting all properties.
function FieldDelta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to FieldDelta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in DetectedEvents.
function DetectedEvents_Callback(hObject, eventdata, handles)
% hObject    handle to DetectedEvents (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
f=filesep;
ExperimentTitle=get(handles.editExperimentTitle,'String');
a=load([ExperimentTitle f 'ExperimentData.mat'],'EventDatabase');
event=a.EventDatabase;

axes(handles.PlotWindow2)
cla
zoom('out')
output=open(handles.filepath);
contents = cellstr(get(handles.variableChooser,'String'));
variable=contents{get(handles.variableChooser,'Value')};
RawSignal=getfield(output,variable);
units=1e3;
switch handles.time_units
    case 'us' 
        units=1e6;
    case 'ms' 
        units=1e3;
    case 's' 
        units=1;
end
x=1:length(RawSignal); x=x./(str2num(get(handles.edit6,'String'))*1000).*units;

plot(x,RawSignal)
    xlabel(['Time [' handles.time_units ']'])
    ylabel(['Current [' handles.current_units ']'])
    set(handles.uipanel8,'Title', 'Input Signal');

if(get(handles.detectedeventsvisible,'Value'))
hold on
markers=eventmarkers(event);
%markers=markers./str2num(get(handles.edit6,'String'))*1000.*units;
plot(x(markers), RawSignal(markers),'r','Marker','*','LineStyle','none');
    xlabel(['Time [' handles.time_units ']'])
    ylabel(['Current [' handles.current_units ']'])
    set(handles.uipanel8,'Title', 'Input Signal');

end


function editSigma_Callback(hObject, eventdata, handles)
% hObject    handle to editSigma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSigma as text
%        str2double(get(hObject,'String')) returns contents of editSigma as a double
user_entry = str2double(get(hObject,'string'));
if isnan(user_entry) || user_entry<0
  msgbox('You must enter a POSITIVE numeric value','Bad Input','error')
  set(hObject,'string',num2str(abs(user_entry)));
end

% --- Executes during object creation, after setting all properties.
function editSigma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSigma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in detectedeventsvisible.
function detectedeventsvisible_Callback(hObject, eventdata, handles)
% hObject    handle to detectedeventsvisible (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of detectedeventsvisible
if(handles.flagAnalysisDone==0)
    set(hObject,'Value',0);
else
DetectedEvents_Callback(hObject, eventdata, handles);
end


% --- Executes on button press in pushbutton9.
function pushbutton9_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
file=fopen([get(handles.editExperimentTitle,'String') filesep 'Global_Informations.txt'],'r');
if(isfield(handles,'introText'))
    set(handles.EventInfos,'String', handles.introText);
elseif(file>0)
    s=[];
    str = textscan(file,'%s','Delimiter','\n');
    for i=1:length(str{1})
        s=[s sprintf('%s\n',str{1}{i})];
    end 
    set(handles.EventInfos,'String', s);
    handles.introText=s;
    guidata(hObject, handles);
else
    h = msgbox('Please analyze a signal before trying to display global informations','Info','help');
end
if file>0
fclose(file);
end

    
function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double
user_entry = str2double(get(hObject,'string'));
if isnan(user_entry) || user_entry<0
  msgbox('You must enter a POSITIVE numeric value','Bad Input','error')
  set(hObject,'string',num2str(abs(user_entry)));
end

% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --------------------------------------------------------------------
function Tools_Callback(hObject, eventdata, handles)
% hObject    handle to Tools (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function Refresh_Callback(hObject, eventdata, handles)
% hObject    handle to Refresh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
pushbutton1_Callback(hObject, eventdata, handles)


% --------------------------------------------------------------------
function uipushtool1_ClickedCallback(hObject, eventdata, handles)
% hObject    handle to uipushtool1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
panelpos1=get(handles.uipanel9,'Position');
panelpos2=get(handles.uipanel8,'Position');

%formats={'ai','bmp','emf','eps','fig','jpg','m','pbm','pcx','pdf','pgm','png','ppm','tif','tiffn'};
set(0,'showhiddenhandles','on'); % Make the GUI figure handle visible
f1=figure('Position',panelpos2); % Create a new figure
copyobj(handles.PlotWindow2,f1); % Copy axes object h into figure f1
f2=figure('Position',panelpos1); % Create a new figure
copyobj(handles.PlotWindow,f2); % Copy axes object h into figure f1



function edit6_Callback(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit6 as text
%        str2double(get(hObject,'String')) returns contents of edit6 as a double
user_entry = str2double(get(hObject,'string'));
if isnan(user_entry) || user_entry<0
  msgbox('You must enter a POSITIVE numeric value','Bad Input','error')
  set(hObject,'string',num2str(abs(user_entry)));
end

% --- Executes during object creation, after setting all properties.
function edit6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --------------------------------------------------------------------
function Help_Callback(hObject, eventdata, handles)
% hObject    handle to Help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function openhelp_Callback(hObject, eventdata, handles)
% hObject    handle to openhelp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
f=filesep;
open(['Manual' f 'html' f 'Help.html']);


% --------------------------------------------------------------------
function web_Callback(hObject, eventdata, handles)
% hObject    handle to web (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
web http://lben.epfl.ch/page-79460-en.html -browser


% --------------------------------------------------------------------
function Units_Callback(hObject, eventdata, handles)
% hObject    handle to Units (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
function time_Callback(hObject, eventdata, handles)
% hObject    handle to time (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
function current_Callback(hObject, eventdata, handles)
% hObject    handle to current (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function pA_Callback(hObject, eventdata, handles)
% hObject    handle to pA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(hObject,'Checked','on');
set(handles.nA,'Checked','off');
handles.current_units='pA';
set(handles.text4,'String', 'Delta [pA]:')
set(handles.text5,'String', 'Sigma [pA]:')
guidata(hObject, handles);

% --------------------------------------------------------------------
function nA_Callback(hObject, eventdata, handles)
% hObject    handle to nA (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(hObject,'Checked','on');
set(handles.pA,'Checked','off');
handles.current_units='nA';
set(handles.text4,'String', 'Delta [nA]:')
set(handles.text5,'String', 'Sigma [nA]:')
guidata(hObject, handles);


% --------------------------------------------------------------------
function us_Callback(hObject, eventdata, handles)
% hObject    handle to us (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.time_units='us';
set(hObject,'Checked','on');
set(handles.s,'Checked','off');
set(handles.ms,'Checked','off');
guidata(hObject, handles);

% --------------------------------------------------------------------
function ms_Callback(hObject, eventdata, handles)
% hObject    handle to ms (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.time_units='ms';
set(hObject,'Checked','on');
set(handles.us,'Checked','off');
set(handles.s,'Checked','off');
guidata(hObject, handles);

% --------------------------------------------------------------------
function s_Callback(hObject, eventdata, handles)
% hObject    handle to s (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.time_units='s';
set(hObject,'Checked','on');
set(handles.us,'Checked','off');
set(handles.ms,'Checked','off');
guidata(hObject, handles);


% --------------------------------------------------------------------
function globalinfo_Callback(hObject, eventdata, handles)
% hObject    handle to globalinfo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
pushbutton9_Callback(hObject, eventdata, handles)


% --- Executes on button press in copy.
function copy_Callback(hObject, eventdata, handles)
% hObject    handle to copy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
string=cellstr(get(handles.EventInfos,'String'));
s=[];
for i=1:length(string)
s=[s sprintf('%s\n',char(string{i}))];
end
clipboard('copy', s)


% --- Executes on selection change in DBselect.
function DBselect_Callback(hObject, eventdata, handles)
% hObject    handle to DBselect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns DBselect contents as cell array
%        contents{get(hObject,'Value')} returns selected item from DBselect
contents = cellstr(get(handles.DBselect,'String'));
chosen=contents{get(handles.DBselect,'Value')};
a=load([handles.ExperimentTitle filesep chosen]);
if(isfield(a, 'EventDatabase'))
handles.MatFile=chosen;
handles.EventDatabase=a.EventDatabase;
handles.ConcatenatedEvents=a.ConcatenatedEvents;
handles.ConcatenatedFits=a.ConcatenatedFits;
guidata(hObject, handles);
else
    errordlg('The specified .mat file does not contain an event database','Error')
end
Refresh_Callback(hObject, eventdata, handles)

% --- Executes during object creation, after setting all properties.
function DBselect_CreateFcn(hObject, eventdata, handles)
% hObject    handle to DBselect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in delete.
function delete_Callback(hObject, eventdata, handles)
% hObject    handle to delete (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(length(handles.EventDatabase)>1)
RemoveEvents(str2double(get(handles.entereventnumber,'String')),handles.ExperimentTitle,handles.MatFile,'_tempDB');
editExperimentTitle_Callback(hObject, eventdata, handles)

a=get(handles.DBselect,'String');
ind=1;
for i=1:length(a)
   if(strcmp(a{i},'_tempDB.mat'))
       ind=i;
   end
end
set(handles.DBselect,'Value', ind)
editExperimentTitle_Callback(hObject, eventdata, handles)
DBselect_Callback(hObject, eventdata, handles)
end

% --------------------------------------------------------------------
function save_Callback(hObject, eventdata, handles)
% hObject    handle to save (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
answer = inputdlg('Please give a name to this new Database','Save Database');
copyfile([handles.ExperimentTitle filesep '_tempDB.mat'],[handles.ExperimentTitle filesep answer{1} '.mat'])
delete([handles.ExperimentTitle filesep '_tempDB.mat'])
editExperimentTitle_Callback(hObject, eventdata, handles)
a=get(handles.DBselect,'String');
ind=1;
for i=1:length(a)
   if(strcmp(a{i},[answer{1} '.mat']))
       ind=i;
   end
end
set(handles.DBselect,'Value', ind)
DBselect_Callback(hObject, eventdata, handles)


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
if(isfield(handles,'ExperimentTitle'))
if(exist([handles.ExperimentTitle filesep '_tempDB.mat'],'file'))
delete([handles.ExperimentTitle filesep '_tempDB.mat'])
end
end
delete(hObject);


% --------------------------------------------------------------------
function RemoveMultiple_Callback(hObject, eventdata, handles)
% hObject    handle to RemoveMultiple (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
answer = inputdlg('Please give a sequence of event numbers you want to remove from the database. E.g. 1 2 3 4 20','Remove Multiple Events');
vector=str2num(answer{1});
RemoveEvents(vector, handles.ExperimentTitle,handles.MatFile,'_tempDB');
editExperimentTitle_Callback(hObject, eventdata, handles)
a=get(handles.DBselect,'String');
ind=1;
for i=1:length(a)
   if(strcmp(a{i},'_tempDB.mat'))
       ind=i;
   end
end
set(handles.DBselect,'Value', ind)
editExperimentTitle_Callback(hObject, eventdata, handles)
DBselect_Callback(hObject, eventdata, handles)


% --- Executes on key press with focus on figure1 and none of its controls.
function figure1_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  structure with the following fields (see FIGURE)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)
a=eventdata.Key;
if(strcmp(a,'leftarrow'))
pushbuttonPrevious_Callback(hObject, eventdata, handles)
end
if(strcmp(a,'rightarrow'))
pushbuttonNext_Callback(hObject, eventdata, handles)
end
if(strcmp(a,'backspace'))
delete_Callback(hObject, eventdata, handles)
end


% --- Executes on mouse press over figure background.
function figure1_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
a=eventdata;


% --- Executes on mouse press over figure background, over a disabled or
% --- inactive control, or over an axes background.
function figure1_WindowButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
pos=get(hObject,'CurrentPoint');
panelpos=get(handles.uipanel8,'Position');
axes(handles.PlotWindow2)
plotpos=get(gca,'Position');
x=pos(1);
y=pos(2);
xleft=panelpos(1)+plotpos(1);
xrigth=xleft+plotpos(3);
ydown=panelpos(2)+plotpos(2);
yup=ydown+plotpos(4);
if(x<xrigth && x>xleft && y<yup && y>ydown)
pt=get(gca,'CurrentPoint');
xloc=pt(1,1);
en=FindEventNumber(handles.EventDatabase, xloc, str2num(get(handles.edit6,'String'))*1000, handles.time_units);
if(en~=0)
set(handles.entereventnumber,'string',num2str(en))
Refresh_Callback(hObject, eventdata, handles)
end
end


% --------------------------------------------------------------------
function rmdoubles_Callback(hObject, eventdata, handles)
% hObject    handle to rmdoubles (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
vector=FindDoubles(handles.EventDatabase);
RemoveEvents(vector, handles.ExperimentTitle,handles.MatFile,'_tempDB');
editExperimentTitle_Callback(hObject, eventdata, handles)
a=get(handles.DBselect,'String');
ind=1;
for i=1:length(a)
   if(strcmp(a{i},'_tempDB.mat'))
       ind=i;
   end
end
set(handles.DBselect,'Value', ind)
editExperimentTitle_Callback(hObject, eventdata, handles)
DBselect_Callback(hObject, eventdata, handles)


% --------------------------------------------------------------------
function rmeventsthresh_Callback(hObject, eventdata, handles)
% hObject    handle to rmeventsthresh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
answer = inputdlg('Please give a length threshold (in the specified time units) to remove events longer than this value.','Remove Multiple Events');
vector=str2num(answer{1});
RemoveEvents(vector, handles.ExperimentTitle,handles.MatFile,'_tempDB','Threshold');
editExperimentTitle_Callback(hObject, eventdata, handles)
a=get(handles.DBselect,'String');
ind=1;
for i=1:length(a)
   if(strcmp(a{i},'_tempDB.mat'))
       ind=i;
   end
end
set(handles.DBselect,'Value', ind)
editExperimentTitle_Callback(hObject, eventdata, handles)
DBselect_Callback(hObject, eventdata, handles)
