/*
 * Decompiled with CFR 0.152.
 */
package tweezers;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Random;
import org.opensourcephysics.display.Arrow;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.display.Circle;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.InteractiveShape;
import org.opensourcephysics.display2d.InterpolatedPlot;
import tweezers.Forces;
import tweezers.GaussianBeam;
import tweezers.LambdaRGBColor;
import tweezers.Operacions;
import tweezers.Parametres;
import tweezers.Raigs;

public class graf2d {
    Color transparent = new Color(0, 0, 0, 0);
    Color orangeplus = new Color(255, 175, 0);
    LambdaRGBColor rgb = new LambdaRGBColor();
    Random r = new Random();
    Parametres par1 = new Parametres();
    GaussianBeam gb = new GaussianBeam();
    InterpolatedPlot intensitymap = new InterpolatedPlot();
    Operacions op = new Operacions();
    int Nraigdmax;
    int Nraigd;
    InteractiveShape bola;
    BoundedShape lent;
    BoundedShape cover;
    InteractiveShape rectanglecamp;
    BoundedShape rectanglecolor;
    Arrow[] force;
    Arrow[] forceshadow;
    BoundedShape[] feix;
    BoundedShape[] reflec;
    BoundedShape[] refrac1;
    BoundedShape[] refrac2;
    BoundedShape[] reflec1;
    BoundedShape perfily;
    BoundedShape perfilz;
    Circle[] punt0;
    Circle[] punt1;
    Circle[] punt2;
    double[][] p0;
    double[][] p1;
    double[][] p2;
    double[][] p3;
    double[][] v0;
    double[][] v1;
    double[][] v2;
    double[][] v1r;
    double[][] p1r;
    double[][] normal;
    double[][] normal2;
    boolean[] talla;
    Forces forces;
    double[] angleout;
    double[] anglein;
    Color gris;
    Color gristransp;
    double Ft;

    public graf2d() {
        this.Nraigdmax = this.par1.Nraigdmax;
        this.bola = InteractiveShape.createEllipse(0.0, 0.0, 2.0 * this.par1.R / this.par1.scale, 2.0 * this.par1.R / this.par1.scale);
        this.rectanglecolor = BoundedShape.createBoundedRectangle(0.0, 0.0, this.par1.field[1] / this.par1.scale, this.par1.field[1] / this.par1.scale);
        this.force = new Arrow[]{new Arrow(0.0, 0.0, 0.0, 1.0), new Arrow(0.0, 0.0, 0.0, 1.0), new Arrow(0.0, 0.0, 0.0, 1.0)};
        this.forceshadow = new Arrow[]{new Arrow(0.0, 0.0, 0.0, 1.0), new Arrow(0.0, 0.0, 0.0, 1.0), new Arrow(0.0, 0.0, 0.0, 1.0)};
        this.feix = new BoundedShape[this.Nraigdmax];
        this.reflec = new BoundedShape[this.Nraigdmax];
        this.refrac1 = new BoundedShape[this.Nraigdmax];
        this.refrac2 = new BoundedShape[this.Nraigdmax];
        this.reflec1 = new BoundedShape[this.Nraigdmax];
        this.perfily = BoundedShape.createBoundedRectangle(0.0, 0.0, 0.0, 1.0);
        this.perfilz = BoundedShape.createBoundedRectangle(0.0, 0.0, 0.0, 1.0);
        this.punt0 = new Circle[this.Nraigdmax];
        this.punt1 = new Circle[this.Nraigdmax];
        this.punt2 = new Circle[this.Nraigdmax];
        this.p0 = new double[this.Nraigdmax][3];
        this.p1 = new double[this.Nraigdmax][3];
        this.p2 = new double[this.Nraigdmax][3];
        this.p3 = new double[this.Nraigdmax][3];
        this.v0 = new double[this.Nraigdmax][3];
        this.v1 = new double[this.Nraigdmax][3];
        this.v2 = new double[this.Nraigdmax][3];
        this.v1r = new double[this.Nraigdmax][3];
        this.p1r = new double[this.Nraigdmax][3];
        this.normal = new double[this.Nraigdmax][3];
        this.normal2 = new double[this.Nraigdmax][3];
        this.talla = new boolean[this.Nraigdmax];
        this.forces = new Forces();
        this.angleout = new double[this.Nraigdmax];
        this.anglein = new double[this.Nraigdmax];
        this.gris = Color.lightGray;
        this.gristransp = new Color(this.gris.getRed(), this.gris.getGreen(), this.gris.getBlue(), 100);
        this.Ft = 0.0;
    }

    public void dibuixar(InteractivePanel panell, Parametres par) {
        this.rectanglecamp = InteractiveShape.createRectangle(0.0, 0.0, par.fieldforces[par.regim] / par.scale, par.fieldforces[par.regim] / par.scale);
        this.rectanglecamp.edgeColor = this.gristransp;
        this.rectanglecamp.color = this.gristransp;
        this.rectanglecamp.setEnabled(false);
        panell.clear();
        panell.setSquareAspect(true);
        panell.setInteractiveMouseHandler(panell);
        this.force[0].setColor(this.orangeplus);
        this.force[1].setColor(Color.RED);
        this.force[2].setColor(Color.BLUE);
        this.forceshadow[0].setColor(Color.BLACK);
        this.forceshadow[1].setColor(Color.BLACK);
        this.forceshadow[2].setColor(Color.BLACK);
        for (int k = 0; k < this.Nraigdmax; ++k) {
            this.feix[k] = BoundedShape.createBoundedRectangle(0.0, 0.0, 0.0, 1.0);
            this.reflec1[k] = BoundedShape.createBoundedRectangle(0.0, 0.0, 0.0, 1.0);
            this.refrac1[k] = BoundedShape.createBoundedRectangle(0.0, 0.0, 0.0, 1.0);
            this.refrac2[k] = BoundedShape.createBoundedRectangle(0.0, 0.0, 0.0, 1.0);
        }
        this.perfily.edgeColor = Color.darkGray;
        this.perfilz.edgeColor = Color.darkGray;
        panell.addDrawable(this.bola);
        this.bola.setXY(0.0, 1.0E-9);
    }

    public void repintaregim(InteractivePanel panell, Parametres par, Raigs raigs) {
        panell.clear();
        double xmax = par.field[par.regim] / 2.0;
        double ymax = par.field[par.regim] / 2.0;
        panell.setPreferredMinMaxX(-xmax, xmax);
        panell.setPreferredMinMaxY(-ymax, ymax);
        this.rectanglecamp.setWidth(par.fieldforces[par.regim] / par.scale);
        this.rectanglecamp.setHeight(par.fieldforces[par.regim] / par.scale);
        double f = par.zcover;
        switch (par.regim) {
            case 0: {
                panell.addDrawable(this.gb.black(par));
                for (int k = 0; k < this.Nraigd; ++k) {
                    panell.addDrawable(this.feix[k]);
                    panell.addDrawable(this.refrac1[k]);
                    panell.addDrawable(this.refrac2[k]);
                    double discr = 2.0 * par.Rcov / (double)(this.Nraigd - 1);
                    this.p0[k][0] = 0.0;
                    this.p0[k][1] = (-par.Rcov + (double)k * discr) / par.scale;
                    this.p0[k][2] = -f / par.scale;
                    this.v0[k][0] = 0.0 - this.p0[k][0];
                    this.v0[k][1] = 0.0 - this.p0[k][1];
                    this.v0[k][2] = 0.0 - this.p0[k][2];
                    this.v0[k] = this.op.norm3d(this.v0[k]);
                    this.pintaraigs(panell, par, raigs);
                }
                break;
            }
            case 1: {
                if (par.P > 0.0) {
                    this.intensitymap = this.gb.IntensityMapYZ(par);
                    panell.addDrawable(this.intensitymap);
                } else {
                    panell.addDrawable(this.gb.black(par));
                }
                panell.addDrawable(this.rectanglecolor);
                this.rectanglecolor.setEnabled(false);
                this.colorejar(par);
                break;
            }
        }
        panell.removeDrawable(this.bola);
        panell.addDrawable(this.bola);
    }

    public void colorejar(Parametres par) {
        Color colorgb;
        this.rectanglecolor.color = colorgb = this.rgb.lambda2RGB(par, 50);
        this.rectanglecolor.edgeColor = colorgb;
    }

    public void pintaraigs(InteractivePanel panell, Parametres par, Raigs raigs) {
        for (int k = 0; k < this.Nraigd; ++k) {
            this.pintaraigk(par, raigs, k);
        }
    }

    public void pintaraigk(Parametres par, Raigs raigs, int k) {
        Color colorgb;
        int alpha;
        if (par.raymode == 0) {
            double rayrelativepower = raigs.p[k] / this.op.max(raigs.p);
            double beampower = par.Puseful / par.scaleP / par.Pmax;
            alpha = (int)(rayrelativepower * beampower * 255.0);
        } else {
            double relativeforce = raigs.dF[k] / this.op.max(raigs.dF);
            alpha = (int)(relativeforce * 255.0);
        }
        this.feix[k].edgeColor = colorgb = this.rgb.lambda2RGB(par, alpha);
        this.refrac1[k].edgeColor = colorgb;
        this.refrac2[k].edgeColor = colorgb;
    }

    public void actualitzar(InteractivePanel panell, Parametres par, Raigs raigs) {
        double size = 2.0 * par.R / par.scale;
        this.bola.setWidth(size);
        this.bola.setHeight(size);
        panell.repaint();
        double field = par.field[par.regim];
        double actualXMax = panell.getXMax();
        if (size > actualXMax) {
            panell.setPreferredMinMax(-size, size, -size, size);
        } else if (size > field) {
            panell.setPreferredMinMax(-size, size, -size, size);
        } else {
            panell.setPreferredMinMax(-field, field, -field, field);
        }
        this.Nraigd = par.Nraigd;
        double[] pc = this.getPosition();
        double[][] F = this.forces.calc(par, raigs, 0.0, pc[1] * par.scale, pc[2] * par.scale);
        double Fx = F[0][0] * Math.pow(10.0, 12.0);
        double Fy = F[0][1] * Math.pow(10.0, 12.0);
        double Fz = F[0][2] * Math.pow(10.0, 12.0);
        this.Ft = Math.sqrt(Fx * Fx + Fy * Fy + Fz * Fz);
        double Fnorm = 0.001;
        double arrowsize = panell.getXMax() / 5.0;
        if (par.regim == 0) {
            double anglelimit = this.op.anglelimit(par.n1, par.n2);
            for (int k = 0; k < this.Nraigd; ++k) {
                this.p1[k] = this.op.intersec(this.p0[k], this.v0[k], pc, par.R / par.scaleR[par.regim]);
                this.feix[k] = this.op.raig(this.feix[k], this.p0[k], this.p1[k]);
                this.talla[k] = this.op.booleantalla(this.p0[k], this.v0[k], pc, par);
                if (this.talla[k]) {
                    this.pintaraigk(par, raigs, k);
                    this.normal[k][0] = this.p1[k][0] - pc[0];
                    this.normal[k][1] = this.p1[k][1] - pc[1];
                    this.normal[k][2] = this.p1[k][2] - pc[2];
                    this.normal[k] = this.op.norm3d(this.normal[k]);
                    this.v1r[k] = this.reflec2d(this.v0[k], this.normal[k]);
                    double m = 10.0;
                    this.p1r[k][0] = this.p1[k][0] + m * this.v1r[k][0];
                    this.p1r[k][1] = this.p1[k][1] + m * this.v1r[k][1];
                    this.p1r[k][2] = this.p1[k][2] + m * this.v1r[k][2];
                    this.reflec1[k] = this.op.raig(this.reflec1[k], this.p1[k], this.p1r[k]);
                    this.anglein[k] = this.op.angle90(this.normal[k], this.v0[k]);
                    if (this.anglein[k] <= anglelimit) {
                        this.v1[k] = this.refrac2d(this.v0[k], this.normal[k], par.n1, par.n2);
                        m = 2.0 * -this.op.pe(this.normal[k], this.v1[k]) * par.R / par.scale;
                        this.p2[k][0] = this.p1[k][0] + m * this.v1[k][0];
                        this.p2[k][1] = this.p1[k][1] + m * this.v1[k][1];
                        this.p2[k][2] = this.p1[k][2] + m * this.v1[k][2];
                        this.refrac1[k] = this.op.raig(this.refrac1[k], this.p1[k], this.p2[k]);
                        this.normal2[k][0] = this.p2[k][0] - pc[0];
                        this.normal2[k][1] = this.p2[k][1] - pc[1];
                        this.normal2[k][2] = this.p2[k][2] - pc[2];
                        this.normal2[k] = this.op.norm3d(this.normal2[k]);
                        this.v2[k] = this.refrac2d(this.v1[k], this.normal2[k], par.n2, par.n1);
                        m = par.field[par.regim] * 10.0;
                        this.p3[k][0] = this.p2[k][0] + m * this.v2[k][0];
                        this.p3[k][1] = this.p2[k][1] + m * this.v2[k][1];
                        this.p3[k][2] = this.p2[k][2] + m * this.v2[k][2];
                        this.refrac2[k] = this.op.raig(this.refrac2[k], this.p2[k], this.p3[k]);
                        this.angleout[k] = this.op.ppangle(this.p2[k], this.p3[k]);
                        continue;
                    }
                    this.refrac1[k].edgeColor = this.transparent;
                    this.refrac2[k].edgeColor = this.transparent;
                    this.anglein[k] = this.op.angle90(this.p0[k], this.p1[k]);
                    this.angleout[k] = this.anglein[k];
                    continue;
                }
                this.refrac1[k].edgeColor = this.transparent;
                this.refrac2[k].edgeColor = this.transparent;
                if (par.raymode == 1) {
                    this.feix[k].edgeColor = this.transparent;
                }
                this.angleout[k] = this.op.ppangle(this.p0[k], this.p1[k]);
            }
        } else {
            this.intensitymap = this.gb.IntensityMapYZ(par);
        }
        for (int i = 0; i < 3; ++i) {
            if (par.selectedforces[i]) {
                double fmod = this.op.mod(F[i]);
                if (fmod > 0.0) {
                    this.force[i].setXlength(F[i][1] * 1.0E12 / par.fnorm[par.regim]);
                    this.force[i].setYlength(F[i][2] * 1.0E12 / par.fnorm[par.regim]);
                } else {
                    this.force[i].setXlength(0.0);
                    this.force[i].setYlength(0.0);
                }
                this.force[i].setXY(this.bola.getX(), this.bola.getY());
                panell.addDrawable(this.force[i]);
                continue;
            }
            panell.removeDrawable(this.force[i]);
        }
        String fmt = "0.00";
        DecimalFormat df = new DecimalFormat(fmt);
        double[][] Fm = new double[3][3];
        panell.repaint();
    }

    public double[] getPosition() {
        double[] rc = new double[]{0.0, this.bola.getX(), this.bola.getY()};
        return rc;
    }

    public BoundedShape qqr(double[] pa, double[] pb) {
        double x0 = pa[1];
        double y0 = pa[2];
        double x1 = pb[1];
        double y1 = pb[2];
        double r = Math.sqrt(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0));
        double angle = Math.atan2(y1 - y0, x1 - x0);
        BoundedShape ray = BoundedShape.createBoundedRectangle(x0 + (x1 - x0) / 2.0, y0 + (y1 - y0) / 2.0, r, 0.0);
        ray.setTheta(angle);
        return ray;
    }

    public double[] refrac2d(double[] vinc, double[] norm, double n1, double n2) {
        double thetanorm = Math.atan2(norm[2], norm[1]);
        double thetainc = Math.atan2(vinc[2], vinc[1]);
        double isign = thetainc - thetanorm;
        double rsign = Math.asin(Math.sin(isign) * n1 / n2);
        double threfracsign = thetanorm - rsign;
        double v1x = Math.cos(threfracsign);
        double v1y = Math.sin(threfracsign);
        double[] vrefrac = new double[]{0.0, v1x, v1y};
        return vrefrac;
    }

    public double[] reflec2d(double[] vinc, double[] norm) {
        double i = this.op.angle90(vinc, norm);
        double[] vreflec = new double[]{0.0, vinc[1] + 2.0 * Math.cos(i) * norm[1], vinc[2] + 2.0 * Math.cos(i) * norm[2]};
        return vreflec;
    }
}

