/*
 * Decompiled with CFR 0.152.
 */
package tweezers;

import java.awt.Color;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.PlottingPanel;
import tweezers.Captions;
import tweezers.Forces;
import tweezers.GaussianBeam;
import tweezers.Operacions;
import tweezers.Parametres;
import tweezers.Raigs;

public class Perfils {
    Captions cap = new Captions();
    Operacions op = new Operacions();
    Forces forces = new Forces();
    GaussianBeam gb = new GaussianBeam();
    Color orangeplus = new Color(255, 150, 0);
    double[][] QY;
    double QYtot;
    double QYs;
    double QYg;
    double[][] QZ;
    double QZtot;
    double QZs;
    double QZg;
    double zleft = 0.0;
    double zright = 0.0;
    double Qleft = 0.0;
    double Qright = 0.0;
    double[] F;
    double[] z;
    Dataset[] datasetZ = new Dataset[]{new Dataset(), new Dataset(), new Dataset()};
    Dataset[] datasetY = new Dataset[]{new Dataset(), new Dataset(), new Dataset()};
    Dataset calibration = new Dataset();
    double ymax;
    double fmaxy = 0.0;
    double fminy = 0.0;

    public void perfilY(PlottingPanel panel, Parametres par, double zc) {
        for (int i = 0; i < 3; ++i) {
            this.datasetZ[i] = new Dataset();
            this.datasetY[i] = new Dataset();
        }
        par.Nraig = par.Nraigperfils;
        Raigs raigs = new Raigs(par);
        this.ymax = par.fieldforces[par.regim] / 2.0;
        double discrY = 2.0 * this.ymax / (double)par.Npointsperfils;
        double ztrap = par.ztrap;
        Dataset dataset = new Dataset();
        dataset.setConnected(true);
        dataset.setSorted(true);
        this.fmaxy = 0.0;
        this.fminy = 0.0;
        for (double yc = -this.ymax; yc <= this.ymax; yc += discrY) {
            this.QY = this.forces.calc(par, raigs, 0.0, yc, ztrap);
            this.QYtot = this.QY[0][1];
            this.QYs = this.QY[1][1];
            this.QYg = this.QY[2][1];
            double[] Qcase = new double[]{this.QYtot, this.QYs, this.QYg};
            if (Qcase[0] > this.fmaxy) {
                this.fmaxy = Qcase[0];
            }
            if (Qcase[0] < this.fminy) {
                this.fminy = Qcase[0];
            }
            for (int i = 0; i < 3; ++i) {
                this.datasetY[i].append(yc / par.scale, Qcase[i] * 1.0E12);
            }
        }
        par.Qxmax = this.fmaxy * 1.0E12;
        double xleft = -par.dx4kx[par.regim];
        double xright = par.dx4kx[par.regim];
        double Fyleft = this.forces.calc(par, raigs, 0.0, xleft, ztrap)[0][1];
        double Fyright = this.forces.calc(par, raigs, 0.0, xright, ztrap)[0][1];
        par.kx = (Fyleft - Fyright) / (xleft - xright);
        for (int i = 0; i < 3; ++i) {
            this.datasetY[i].setConnected(true);
            this.datasetY[i].setSorted(true);
            this.datasetY[i].setMarkerShape(6);
        }
        this.datasetY[0].setLineColor(this.orangeplus);
        this.datasetY[1].setLineColor(Color.RED);
        this.datasetY[2].setLineColor(Color.BLUE);
        par.Nraig = par.Nraigforce;
    }

    public void perfilZ(PlottingPanel panell, Parametres par, double yc) {
        panell.clear();
        par.Nraig = par.Nraigperfils;
        par.correction3D = true;
        Raigs raigs = new Raigs(par);
        par.correction3D = false;
        double zmax = par.fieldforces[par.regim] / 2.0;
        double discr = par.fieldforces[par.regim] / (double)(par.Npointsperfils - 1);
        double[][] Fy = new double[3][par.Npointsperfils];
        int k = 0;
        double Qzantic = 0.0;
        double zcprevious = 0.0;
        par.ztrap = -1.0;
        boolean countztraps = false;
        par.ztrapfound = false;
        int count = 0;
        int indexzeq = 0;
        double[] F = new double[par.Npointsperfils];
        double[] z = new double[par.Npointsperfils];
        double[] qz = new double[par.Npointsperfils];
        for (double zc = -zmax; zc <= zmax; zc += discr) {
            this.QZ = this.forces.calc(par, raigs, 0.0, yc, zc);
            this.QZtot = this.QZ[0][2];
            this.QZs = this.QZ[1][2];
            this.QZg = this.QZ[2][2];
            F[count] = this.QZtot;
            z[count] = zc;
            qz[count] = this.QZtot * 1.0E12;
            ++count;
            if (!par.ztrapfound && Qzantic * this.QZ[0][2] < 0.0 && zc > 0.0) {
                this.Qleft = Qzantic;
                this.Qright = this.QZ[0][2];
                this.zleft = zcprevious;
                this.zright = zc;
                par.ztrap = -this.Qleft * ((this.zright - this.zleft) / (this.Qright - this.Qleft)) + this.zleft;
                par.ztrapfound = true;
                indexzeq = count;
                par.kz = (F[indexzeq - 1] - F[indexzeq + 1]) / (z[indexzeq - 1] - z[indexzeq + 1]);
                double Qzfiantic = 1.0;
                double zfineantic = this.zleft;
                boolean zfinefound = false;
                for (double zfine = this.zleft; zfine <= this.zright; zfine += (this.zright - this.zleft) / (double)par.Npointsrefinats) {
                    double Qzfi = this.forces.calc(par, raigs, 0.0, yc, zfine)[0][2];
                    if (!zfinefound && Qzfiantic * Qzfi < 0.0 && zfine > 0.0) {
                        zfinefound = true;
                        double Fleftfi = Qzfiantic;
                        double Frightfi = Qzfi;
                        double zleftfi = zfineantic;
                        double zrightfi = zfine;
                        par.ztrap = -Fleftfi * ((zrightfi - zleftfi) / (Frightfi - Fleftfi)) + zleftfi;
                        par.kz = (Frightfi - Fleftfi) / (zrightfi - zleftfi);
                    }
                    zfineantic = zfine;
                    Qzfiantic = Qzfi;
                }
            }
            Qzantic = this.QZ[0][2];
            zcprevious = zc;
            Fy[0][k] = this.QZtot;
            Fy[1][k] = this.QZs;
            Fy[2][k] = this.QZg;
            for (int i = 0; i < 3; ++i) {
                this.datasetZ[i].append(zc / par.scale, Fy[i][k] * 1.0E12);
            }
            ++k;
        }
        if (!par.ztrapfound) {
            par.ztrap = 0.0;
        } else {
            par.Qzmaxdown = this.op.max(qz);
            par.Qzmaxup = this.op.min(qz);
        }
        int Npoints = k;
        for (int i = 0; i < 3; ++i) {
            this.datasetZ[i].setConnected(true);
            this.datasetZ[i].setSorted(true);
            this.datasetZ[i].setMarkerShape(6);
        }
        this.datasetZ[0].setLineColor(this.orangeplus);
        this.datasetZ[1].setLineColor(Color.RED);
        this.datasetZ[2].setLineColor(Color.BLUE);
        par.Nraig = par.Nraigforce;
    }

    public void calibrate(PlottingPanel panellY, Parametres par) {
        this.calibration = new Dataset();
        double xleft = this.fmaxy / -par.stiffness / par.scale;
        double xright = this.fminy / -par.stiffness / par.scale;
        this.calibration.append(xleft, this.fmaxy * 1.0E12);
        this.calibration.append(xright, this.fminy * 1.0E12);
        this.calibration.setConnected(true);
        this.calibration.setMarkerShape(6);
        this.calibration.setLineColor(new Color(0, 200, 0));
        this.calibration.setMarkerColor(Color.GREEN);
        par.calibrated = true;
    }

    public void representar(PlottingPanel panellZ, PlottingPanel panellY, Parametres par) {
        panellZ.clear();
        panellY.clear();
        for (int i = 2; i >= 0; --i) {
            if (par.selectedforces[i]) {
                panellZ.addDrawable(this.datasetZ[i]);
                panellY.addDrawable(this.datasetY[i]);
            }
            if (!par.calibrated) continue;
            this.calibrate(panellY, par);
            panellY.addDrawable(this.calibration);
        }
        panellZ.repaint();
        panellY.repaint();
    }
}

