/*
 * Decompiled with CFR 0.152.
 */
package tweezers;

import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import tweezers.Operacions;

public class Parametres {
    Operacions op = new Operacions();
    int lang = 0;
    boolean track = false;
    double stiffness;
    double kz;
    double kx;
    double Qzmaxup;
    double Qzmaxdown;
    double Qxmax;
    boolean correction3D = false;
    int raymode = 0;
    boolean traceractivated;
    boolean forcedtrace = false;
    boolean allow_ray_brightness_mode = false;
    double scaleP = 0.001;
    double Pmin = 0.0;
    double Pmax = 100.0;
    double Pdefault;
    double P = this.Pdefault = 50.0 * this.scaleP;
    double incrP = 1.0;
    int nticsP = 100;
    double scaleL = Math.pow(10.0, -9.0);
    double lambdadefault;
    double lambda = this.lambdadefault = 543.0 * this.scaleL;
    double lambdamin = 300.0;
    double lambdamax = 1200.0;
    double incrlambda = 1.0;
    int nticslambda = (int)(1.0 + (this.lambdamax - this.lambdamin) / this.incrlambda);
    double n1min = 1.33;
    double n1max = 1.6;
    double n1default;
    double n1 = this.n1default = 1.331;
    double incrn1 = 0.01;
    int nticsn1 = (int)(1.0 + (this.n1max - this.n1min) / this.incrn1);
    double n2min = 1.0;
    double n2max = 2.0;
    double n2default;
    double n2 = this.n2default = 1.58;
    double incrn2 = 0.01;
    int nticsn2 = (int)(1.0 + (this.n2max - this.n2min) / this.incrn2);
    double NAmin = 0.1;
    double NAmax = 1.3;
    double NAdefault;
    double NA = this.NAdefault = 1.25;
    double incrNA = 0.01;
    int nticsNA = (int)(1.0 + (this.NAmax - this.NAmin) / this.incrNA);
    double scalew0 = 1.0E-6;
    double w0max = 2.0 * this.lambdamin * this.scaleL / (Math.PI * this.NAmin);
    double w0min = 2.0 * this.lambdamax * this.scaleL / (Math.PI * this.NAmax);
    double w0default;
    double w0 = this.w0default = 2.0 * this.lambda / 2.0420352248333655;
    double incrw0 = 1.0E-9;
    int nticsw0 = (int)(1.0 + (this.w0max - this.w0min) / this.incrw0);
    double[] scaleR = new double[]{Math.pow(10.0, -6.0), Math.pow(10.0, -9.0)};
    double[] Rmax = new double[]{1.0E-5, 5.0E-8};
    double[] Rmin = new double[]{1.0E-6, 1.0E-8};
    double[] Rdefault = new double[]{5.0E-6, 5.0E-8};
    double R = this.Rdefault[0];
    double[] incrR = new double[]{1.0E-7, 1.0E-9};
    int[] nticsR = new int[]{(int)(1.0 + (this.Rmax[0] - this.Rmin[0]) / this.incrR[0]), (int)(1.0 + (this.Rmax[1] - this.Rmin[1]) / this.incrR[1])};
    double scalevisc = 0.001;
    double visc = 8.9 * Math.pow(10.0, -4.0);
    double viscmax = 0.01;
    double viscmin = 1.0E-4;
    double incrvisc = 0.01 * this.scalevisc;
    int nticsvisc = (int)(1.0 + (this.viscmax - this.viscmin) / this.incrvisc);
    boolean water = false;
    double T = 300.0;
    double Tmax = 330.0;
    double Tmin = 270.0;
    double incrT = 1.0;
    int nticsT = (int)((this.Tmax - this.Tmin) / this.incrT);
    int regim = 0;
    int perfil = 0;
    int counts = 0;
    boolean initialized = false;
    boolean showforcefieldrectangle = false;
    boolean calibrated = false;
    boolean showplotdetails = false;
    double pupil2waist = 1.0;
    double waist2pupil = 1.0;
    double waist2pupilmax = 5.0;
    double waist2pupilmin = 0.1;
    double waist2pupildefault = 1.0;
    double incrwaist2pupil = 0.01;
    int nticswaist2pupil = (int)((this.waist2pupilmax - this.waist2pupilmin) / this.incrwaist2pupil) + 1;
    double[] zoomdefault = new double[]{1.5, 2.5};
    double zoom = this.zoomdefault[this.regim];
    double[] zoomin = new double[]{0.5, 0.5};
    double[] zoomax = new double[]{2.0, 5.0};
    double[] incrzoom = new double[]{0.05, 0.05};
    int[] nticszoom = new int[]{(int)((this.zoomax[0] - this.zoomin[0]) / this.incrzoom[0]), (int)((this.zoomax[1] - this.zoomin[1]) / this.incrzoom[1])};
    double zcover = 2.0E-5;
    double ztrap;
    double fp = 0.5;
    double fs = 0.5;
    double[] fnorm = new double[]{20.0, 50.0};
    int Nraigd = 100;
    int Nraigforce = 100;
    int Nraigperfils = 100;
    int Nraig = this.Nraigforce;
    int Nraigdmax = this.Nraigd;
    int Nraigdmin = 0;
    int Nraigmax = Math.max(this.Nraigforce, this.Nraigperfils);
    int Npointsperfils = 100;
    int Npointsrefinats = 30;
    double[] dx4kx = new double[]{1.0E-9, 1.0E-12};
    double wcov;
    double timemax = 1.0;
    double[] dtdefault = new double[]{1.0E-4, 5.0E-7};
    double dt = this.dtdefault[this.regim];
    double dtMax = 0.01;
    double dtMin = 1.0E-7;
    int nticsdt = 10000;
    double t = 0.0;
    double estimatedNA;
    int Npath = 100000;
    double dtXY = 1.0E-5;
    double dens = 1000.0;
    double c = 3.0E8;
    double kb = 1.38 * Math.pow(10.0, -23.0);
    double scale = 1.0E-6;
    double[] field = new double[]{5.0, 1.0};
    double[] binwidth = new double[]{0.01, 0.001};
    double Rpe;
    double Rcov;
    double k;
    double m;
    double L;
    double gamma;
    int Npassos;
    double sigma;
    double D;
    double kmedi;
    double[] fieldforcesdefault = new double[]{4.0 * this.Rdefault[0], 4.0 * this.Rdefault[1]};
    double[] fieldforces = this.fieldforcesdefault;
    double Puseful;
    double thmax0;
    double thmax;
    double anglelimit;
    boolean changed = false;
    boolean showrays = false;
    boolean showreflected = false;
    boolean showEMintensity = false;
    double useviscosity = 0.0;
    double useBM = 0.0;
    int nraystoshow = 3;
    boolean ztrapfound = false;
    int numraig = 2;
    int q = 0;
    boolean[] selectedforces = new boolean[]{false, false, false};
    int feix = 0;
    XMLControl xmlpar = new XMLControlElement();
    static String[] lasers = new String[]{"HeNe (633nm)", "C02 (9600)", "C02((10600)"};

    public void calcParDependents() {
        this.pupil2waist = 1.0 / this.waist2pupil;
        this.k = Math.PI * 2 / this.lambda;
        this.kmedi = this.k * this.n1;
        this.m = this.dens * 4.0 / 3.0 * Math.PI * Math.pow(this.R, 3.0);
        this.gamma = Math.PI * 6 * this.visc * this.R;
        this.sigma = 2.0 * this.kb * this.T / this.gamma;
        this.D = this.kb * this.T / this.gamma;
        this.w0max = this.lambda / (Math.PI * this.NAmin);
        this.w0min = this.lambda / (Math.PI * this.NAmax);
        this.anglelimit = this.n2 < this.n1 ? Math.asin(this.n2 / this.n1) : 1.5707963267948966;
        if (this.water) {
            this.visc = 2.414E-5 * Math.pow(10.0, 247.8 / (this.T - 140.0));
        }
        if (this.regim == 0) {
            this.thmax = Math.asin(this.NA / this.n1);
            this.Rcov = this.zcover * Math.tan(this.thmax);
            this.wcov = this.Rcov / this.pupil2waist;
            this.Puseful = this.P * (1.0 - Math.exp(-2.0 * Math.pow(this.pupil2waist, 2.0)));
        } else {
            this.L = this.w0 * this.w0 * Math.PI / this.lambda;
            this.estimatedNA = this.lambda / (Math.PI * this.w0);
        }
    }

    public void write(String filename) {
        if (!filename.endsWith(".xml")) {
            filename = filename + ".xml";
        }
        this.xmlpar.setValue("Power", this.P);
        this.xmlpar.setValue("Wavelength", this.lambda);
        this.xmlpar.setValue("n_medium", this.n1);
        this.xmlpar.setValue("n_bead", this.n2);
        this.xmlpar.setValue("NA", this.NA);
        this.xmlpar.setValue("Overfilling", this.waist2pupil);
        this.xmlpar.setValue("Radius", this.R);
        this.xmlpar.setValue("Viscosity", this.visc);
        this.xmlpar.setValue("Temperature", this.T);
        this.xmlpar.setValue("Time Step", this.dt);
        this.xmlpar.setValue("Beam waist (Rayleigh)", this.w0);
        this.xmlpar.write(filename);
    }

    public void read(String filename) {
        this.xmlpar.read(filename);
        this.P = this.xmlpar.getDouble("Power");
        this.lambda = this.xmlpar.getDouble("Wavelength");
        this.n1 = this.xmlpar.getDouble("n_medium");
        this.n2 = this.xmlpar.getDouble("n_bead");
        this.NA = this.xmlpar.getDouble("NA");
        this.waist2pupil = this.xmlpar.getDouble("Overfilling");
        this.R = this.xmlpar.getDouble("Radius");
        this.visc = this.xmlpar.getDouble("Viscosity");
        this.T = this.xmlpar.getDouble("Temperature");
        this.dt = this.xmlpar.getDouble("Time Step");
        this.w0 = this.xmlpar.getDouble("Beam waist (Rayleigh)");
    }

    public Parametres() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
    }
}

