/*
 * Decompiled with CFR 0.152.
 */
package tweezers;

import java.awt.Color;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.InterpolatedPlot;
import tweezers.GaussianBeam;
import tweezers.LambdaRGBColor;
import tweezers.Parametres;

public class Overfilling {
    LambdaRGBColor rgb = new LambdaRGBColor();
    GaussianBeam gb = new GaussianBeam();
    BoundedShape pupil;
    InterpolatedPlot beam;
    int size = 10;
    BoundedShape rectanglecolor = BoundedShape.createBoundedRectangle(0.0, 0.0, this.size, this.size);
    PlottingPanel plot = new PlottingPanel("", "", "");
    Dataset beamprofile = new Dataset();
    BoundedShape pupileft = BoundedShape.createBoundedRectangle(0.0, 0.0, 0.1, 0.1);
    BoundedShape pupilright = BoundedShape.createBoundedRectangle(0.0, 0.0, 0.1, 0.1);

    public void dibuixar1D(DrawingPanel panel, Parametres par) {
        this.pupileft.color = Color.BLACK;
        this.pupileft.edgeColor = Color.BLACK;
        this.pupileft.setWidth(this.size);
        panel.addDrawable(this.pupileft);
        this.pupilright.color = Color.BLACK;
        this.pupilright.edgeColor = Color.BLACK;
        this.pupilright.setWidth(this.size);
        panel.addDrawable(this.pupilright);
        this.beamprofile.setConnected(true);
        this.beamprofile.setMarkerShape(6);
    }

    public void actualitzar1D(DrawingPanel panel, Parametres par) {
        this.beamprofile.clear();
        double pupil = 5.0;
        double xmax = 2.0 * pupil;
        double w = pupil / par.pupil2waist;
        double discrx = 2.0 * xmax / 100.0;
        for (double x = -xmax; x < xmax; x += discrx) {
            double intensity = Math.exp(-2.0 * x * x / (w * w));
            this.beamprofile.append(x, intensity);
        }
        panel.addDrawable(this.beamprofile);
        this.pupileft.setXY(pupil / 2.0 + (double)(this.size / 2), this.beamprofile.getYMax());
        this.pupilright.setXY(-pupil / 2.0 - (double)(this.size / 2), this.beamprofile.getYMax());
        this.pupileft.setHeight((this.beamprofile.getYMax() - this.beamprofile.getYMin()) / 20.0);
        this.pupilright.setHeight((this.beamprofile.getYMax() - this.beamprofile.getYMin()) / 20.0);
        panel.repaint();
    }

    public void dibuixar(DrawingPanel panel, Parametres par) {
        this.beam = this.gb.beamXY(par);
        panel.setBounds(-this.size, this.size, -this.size, this.size);
        panel.setShowCoordinates(false);
        this.pupil = BoundedShape.createBoundedCircle(0.0, 0.0, 0.8 * (double)this.size * 2.0);
        this.pupil.color = Color.WHITE;
        panel.addDrawable(this.pupil);
        panel.addDrawable(this.beam);
        this.actualitzar(panel, par);
    }

    public void actualitzar(DrawingPanel panel, Parametres par) {
        this.beam = this.gb.beamXY(par);
        this.pupil = BoundedShape.createBoundedCircle(0.0, 0.0, 2.0 * par.pupil2waist);
        this.actualitzarcolor(panel, par);
        panel.clear();
        panel.addDrawable(this.beam);
        panel.addDrawable(this.pupil);
        panel.repaint();
    }

    public void actualitzarcolor(DrawingPanel panel, Parametres par) {
        this.pupil.edgeColor = this.pupil.color = this.rgb.lambda2RGB(par, 150);
        panel.repaint();
    }
}

