/*
 * Decompiled with CFR 0.152.
 */
package tweezers;

import java.util.Random;
import org.opensourcephysics.display.BoundedShape;
import org.opensourcephysics.numerics.Util;
import tweezers.Forces;
import tweezers.Parametres;
import tweezers.Raigs;

public class Operacions {
    public double mod(double[] F) {
        double modF = Math.sqrt(F[0] * F[0] + F[1] * F[1] + F[2] * F[2]);
        return modF;
    }

    public double[] norm(double[] v) {
        double modul = this.mod(v);
        double[] vnorm = new double[]{v[0] / modul, v[1] / modul};
        vnorm[2] = v[2] / modul;
        return vnorm;
    }

    public double[] norm3d(double[] v) {
        double modul = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        double[] vnorm = new double[]{v[0] / modul, v[1] / modul, v[2] / modul};
        return vnorm;
    }

    public double pe(double[] v, double[] w) {
        double pe = v[0] * w[0] + v[1] * w[1] + v[2] * w[2];
        return pe;
    }

    public double theta(double[] v, double[] w) {
        double cos = this.pe(v, w) / (this.mod(v) * this.mod(w));
        return Math.acos(cos);
    }

    public double angle90(double[] v, double[] w) {
        double cos = this.pe(v, w) / (this.mod(v) * this.mod(w));
        if (cos < 0.0) {
            cos = -cos;
        }
        if (cos > 1.0) {
            cos = 1.0;
        }
        double acos = Math.acos(cos);
        return acos;
    }

    public double[] rotar(double[] v, double th) {
        double[] vr = new double[]{v[0] * Math.cos(th) - v[1] * Math.sin(th), v[0] * Math.sin(th) + v[1] * Math.cos(th)};
        return vr;
    }

    public double[] ec2(double a, double b, double c) {
        double[] x = new double[]{(-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a), (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)};
        return x;
    }

    double[] gf(double x, double y, double z, Parametres par) {
        double[] grad = new double[]{par.k * z * x / (z * z + par.L * par.L), par.k * z * y / (z * z + par.L * par.L), par.k + par.k * (x * x + y * y) / 2.0 * (par.L * par.L - z * z) / Math.pow(z * z + par.L * par.L, 2.0) - par.L / (par.L * par.L + z * z)};
        grad = this.norm(grad);
        return grad;
    }

    public BoundedShape raig(BoundedShape raig1, double[] p0, double[] p1) {
        double x0 = p0[1];
        double y0 = p0[2];
        double x1 = p1[1];
        double y1 = p1[2];
        double xm = x0 + (x1 - x0) / 2.0;
        double ym = y0 + (y1 - y0) / 2.0;
        raig1.setXY(xm, ym);
        raig1.setHeight(Math.sqrt(Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0)) * 1.0);
        raig1.setTheta(Math.atan(-(x1 - x0) / (y1 - y0)));
        return raig1;
    }

    public boolean booleantalla(double[] p, double[] v, double[] pc, Parametres par) {
        double x0 = p[0];
        double xc = pc[0];
        double vx = v[0];
        double y0 = p[1];
        double yc = pc[1];
        double vy = v[1];
        double z0 = p[2];
        double zc = pc[2];
        double vz = v[2];
        double b = 2.0 * ((x0 - xc) * vx + (y0 - yc) * vy + (z0 - zc) * vz);
        double a = vx * vx + vy * vy + vz * vz;
        double c = (x0 - xc) * (x0 - xc) + (y0 - yc) * (y0 - yc) + (z0 - zc) * (z0 - zc) - Math.pow(par.R / par.scale, 2.0);
        boolean booleantalla = b * b - 4.0 * a * c >= 0.0;
        return booleantalla;
    }

    public double[] intersec(double[] p0, double[] v, double[] pc, double R) {
        double m;
        double[] p1 = new double[3];
        double x0 = p0[0];
        double xc = pc[0];
        double vx = v[0];
        double y0 = p0[1];
        double yc = pc[1];
        double vy = v[1];
        double z0 = p0[2];
        double zc = pc[2];
        double vz = v[2];
        double b = 2.0 * ((x0 - xc) * vx + (y0 - yc) * vy + (z0 - zc) * vz);
        double a = vx * vx + vy * vy + vz * vz;
        double c = (x0 - xc) * (x0 - xc) + (y0 - yc) * (y0 - yc) + (z0 - zc) * (z0 - zc) - R * R;
        if (b * b - 4.0 * a * c >= 0.0) {
            double m1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            double m2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            m = m1 > 0.0 ? (m2 > 0.0 ? Math.min(m1, m2) : m1) : (m2 > 0.0 ? m2 : Math.abs(Math.max(m1, m2)));
        } else {
            m = this.mod(p0) * 2.0;
        }
        p1[0] = p0[0] + m * v[0];
        p1[1] = p0[1] + m * v[1];
        p1[2] = p0[2] + m * v[2];
        return p1;
    }

    public double anglelimit(double n1, double n2) {
        double anglelimit = n2 < n1 ? Math.asin(n2 / n1) : 1.5707963267948966;
        return anglelimit;
    }

    public double brownianforce(Parametres par) {
        Random r = new Random();
        double x = r.nextGaussian();
        double sigma = Math.sqrt(4.0 * par.gamma * par.kb * par.T);
        double meanforce = 0.0;
        double f = meanforce + sigma * x;
        return f;
    }

    public double[][] calculateYZpath(Parametres par, Raigs raigs, double[] pc) {
        Forces forces = new Forces();
        Random r = new Random();
        double[][] data = new double[par.Npath][3];
        double t = 0.0;
        data[0][0] = 0.0;
        data[0][1] = pc[1];
        data[0][2] = pc[2];
        for (int i = 1; i < par.Npath; ++i) {
            double[] f = forces.calc(par, raigs, 0.0, data[i - 1][1], data[i - 1][2])[par.q];
            data[i][0] = data[i - 1][0] + par.dt;
            data[i][1] = data[i - 1][1] + 1.0 / par.gamma * f[1] + Math.sqrt(2.0 * par.D * par.dt) * r.nextGaussian();
            data[i][2] = data[i - 1][2] + 1.0 / par.gamma * f[1] + Math.sqrt(2.0 * par.D * par.dt) * r.nextGaussian();
        }
        return data;
    }

    double variance(double[] x, Parametres par) {
        double sum = 0.0;
        double mean = this.meanx(x, par);
        for (int i = 0; i < par.counts; ++i) {
            sum += Math.pow(x[i] - mean, 2.0);
        }
        double variance = sum /= (double)par.counts;
        return variance;
    }

    double meanx(double[] x, Parametres par) {
        double sum = 0.0;
        for (int i = 0; i < par.counts; ++i) {
            sum += x[i];
        }
        double mean = sum / (double)par.counts;
        return mean;
    }

    double[] rot(double[] v, double theta) {
        double vx = v[1];
        double vy = v[2];
        double[] r = new double[3];
        return r;
    }

    double max(double[] x) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] > max)) continue;
            max = x[i];
        }
        return max;
    }

    double min(double[] x) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < x.length; ++i) {
            if (!(x[i] < min)) continue;
            min = x[i];
        }
        return min;
    }

    public double w(double z, Parametres par) {
        double zR = par.L;
        double w = par.w0 * Math.sqrt(1.0 + Math.pow(z / zR, 2.0));
        return w;
    }

    public double I0(Parametres par) {
        double I0 = par.Puseful * 2.0 / (Math.PI * Math.pow(par.w0, 2.0));
        return I0;
    }

    public double I(double r, double z, Parametres par) {
        double I = this.I0(par) * Math.pow(par.w0 / this.w(z, par), 2.0) * Math.exp(-2.0 * (r * r) / Math.pow(this.w(z, par), 2.0));
        return I;
    }

    public double ppangle(double[] p0, double[] p1) {
        double x0 = p0[1];
        double y0 = p0[2];
        double x1 = p1[1];
        double y1 = p1[2];
        double theta = Math.atan(-(x1 - x0) / (y1 - y0));
        return theta;
    }

    public double thetarefrac(double n1, double n2, double thetain) {
        double anglelimit = this.anglelimit(n1, n2);
        double thetarefrac = thetain < anglelimit ? Math.asin(n1 * Math.sin(thetain) / n2) : Math.asin(n1 * Math.sin(anglelimit * 0.9999) / n2);
        return thetarefrac;
    }

    public double[][] meanfilter(double[] x, double[] f, int n) {
        int N = x.length;
        int Nfilt = N / n + 1;
        double[] xfilt = new double[Nfilt];
        double[] ffilt = new double[Nfilt];
        int k = 0;
        for (int i = 0; i < N; i += n) {
            xfilt[k] = Util.computeAverage(x, i, n);
            ffilt[k] = Util.computeAverage(f, i, n);
            ++k;
        }
        double[][] output = new double[2][k];
        output[0] = xfilt;
        output[1] = ffilt;
        return output;
    }

    public double coherce(double x, double xmin, double xmax) {
        if (x < xmin) {
            x = xmin;
        }
        if (x > xmax) {
            x = xmax;
        }
        return x;
    }

    public double string2double(String s) {
        s = s.replace(',', '.');
        double d = Double.valueOf(s);
        return d;
    }

    public double sumar(double[] x) {
        double suma = 0.0;
        for (int i = 0; i < x.length; ++i) {
            suma += x[i];
        }
        return suma;
    }
}

