/*
 * Decompiled with CFR 0.152.
 */
package tweezers;

import java.awt.Color;
import org.opensourcephysics.display2d.InterpolatedPlot;
import tweezers.Operacions;
import tweezers.Parametres;

public class GaussianBeam {
    Operacions op = new Operacions();

    public InterpolatedPlot IntensityMapYZ(Parametres par) {
        int j;
        int N = 100;
        double smax = par.field[par.regim] * 2.1;
        double discret = smax / (double)N;
        double[][] data = new double[N][N];
        InterpolatedPlot plot = new InterpolatedPlot();
        plot.setAll(data, -smax, smax, -smax, smax);
        plot.setPaletteType(1);
        double Imax = 0.0;
        for (int i = 0; i < N; ++i) {
            double y = plot.indexToX(i) * par.scale;
            for (j = 0; j < N; ++j) {
                double z = plot.indexToY(j) * par.scale;
                data[i][j] = Math.pow(this.op.I(y, z, par), 0.25);
                if (!(data[i][j] > Imax)) continue;
                Imax = data[i][j];
            }
        }
        double Itot = 0.0;
        for (int i = 0; i < N; ++i) {
            for (j = 0; j < N; ++j) {
                Itot += data[i][j];
            }
        }
        plot.setAll(data);
        plot.setAutoscaleZ(false, 0.0, Imax / par.P * par.Pmax * par.scaleP);
        return plot;
    }

    public InterpolatedPlot black(Parametres par) {
        int N = 2;
        double[][] data = new double[N][N];
        InterpolatedPlot plot = new InterpolatedPlot();
        double smax = 25.0;
        plot.setAll(data, -smax, smax, -smax, smax);
        plot.setPaletteType(1);
        for (int i = 0; i < N; ++i) {
            double y = plot.indexToX(i) * par.scale;
            for (int j = 0; j < N; ++j) {
                double z = plot.indexToY(j) * par.scale;
                data[i][j] = 0.0;
            }
        }
        plot.setAll(data);
        return plot;
    }

    public InterpolatedPlot beamXY(Parametres par) {
        int i;
        int nscale = 100;
        Color[] transpalette = new Color[nscale];
        double[] a = new double[4];
        for (int i2 = 0; i2 < 100; ++i2) {
            transpalette[i2] = new Color(0, 255, 0, i2);
        }
        int N = 100;
        double pupil = par.pupil2waist;
        double w = 1.0;
        double smax = par.waist2pupilmax;
        double discret = smax / (double)N;
        double[][] data = new double[N][N];
        InterpolatedPlot plot = new InterpolatedPlot();
        plot.setAll(data, -smax, smax, -smax, smax);
        plot.setPaletteType(1);
        double Imax = 0.0;
        for (i = 0; i < N; ++i) {
            double x = plot.indexToX(i);
            for (int j = 0; j < N; ++j) {
                double y = plot.indexToY(j);
                data[i][j] = Math.exp(-2.0 * (x * x + y * y) / (w * w));
                if (!(data[i][j] > Imax)) continue;
                Imax = data[i][j];
            }
        }
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                data[i][j] = data[i][j] / Imax;
            }
        }
        plot.setAll(data);
        return plot;
    }
}

