/*
 * Decompiled with CFR 0.152.
 */
package tweezers;

import tweezers.GaussianBeam;
import tweezers.Parametres;
import tweezers.Raigs;

public class Forces {
    GaussianBeam gb = new GaussianBeam();

    public Forces() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public double[][] calc(Parametres par, Raigs raigs, double xc, double yc, double zc) {
        switch (par.regim) {
            case 0: {
                return this.calcMie(par, raigs, xc, yc, zc);
            }
            case 1: {
                return this.calcRayleigh(par, this.gb, xc, yc, zc);
            }
        }
        double[][] zeros = new double[3][3];
        zeros[0] = new double[]{0.0, 0.0, 0.0};
        zeros[1] = new double[]{0.0, 0.0, 0.0};
        zeros[2] = new double[]{0.0, 0.0, 0.0};
        return zeros;
    }

    public double[][] calcMie(Parametres par, Raigs raigs, double xc, double yc, double zc) {
        double f = par.zcover;
        double R = par.R;
        double n1 = par.n1;
        double n2 = par.n2;
        double xf = 0.0;
        double yf = 0.0;
        double zf = 0.0;
        int Nraig = par.Nraig;
        double[] vr = raigs.vr;
        double[] vbeta = raigs.vbeta;
        double[] nx = raigs.nx;
        double[] ny = raigs.ny;
        double[] nz = raigs.nz;
        double[] p = raigs.p;
        double[][] Q = new double[3 + Nraig][3];
        double Qx = 0.0;
        double Qy = 0.0;
        double Qz = 0.0;
        double Qsx = 0.0;
        double Qsy = 0.0;
        double Qsz = 0.0;
        double Qgx = 0.0;
        double Qgy = 0.0;
        double Qgz = 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                Q[i][j] = 0.0;
            }
        }
        for (int k = 0; k < Nraig; ++k) {
            double C;
            double r = vr[k];
            double beta = vbeta[k];
            double x0 = raigs.x0[k];
            double y0 = raigs.y0[k];
            double z0 = -f;
            double x1 = xf + nx[k] / nz[k] * f;
            double y1 = yf + ny[k] / nz[k] * f;
            double z1 = zf;
            double fi = Math.atan(r / f);
            double alpha = 1.5707963267948966 - fi;
            double betap = Math.atan(yc * Math.sin(beta) / (yc * Math.cos(beta) + zc / Math.tan(alpha)));
            double gammap = Math.acos(Math.cos(alpha) * Math.cos(betap));
            double d = zc * Math.cos(betap) / Math.tan(alpha) + yc * Math.cos(beta - betap);
            double B = 2.0 * ((x1 - x0) * (x0 - xc) + (y1 - y0) * (y0 - yc) + (z1 - z0) * (z0 - zc));
            double A = Math.pow(x1 - x0, 2.0) + Math.pow(y1 - y0, 2.0) + Math.pow(z1 - z0, 2.0);
            if (B * B - 4.0 * A * (C = Math.pow(x0 - xc, 2.0) + Math.pow(y0 - yc, 2.0) + Math.pow(z0 - zc, 2.0) - R * R) >= 0.0) {
                double m = (-B - Math.sqrt(B * B - 4.0 * A * C)) / (2.0 * A);
                Q[k + 3][0] = (x0 + m * (x1 - x0)) / par.scale;
                Q[k + 3][1] = (y0 + m * (y1 - y0)) / par.scale;
                Q[k + 3][2] = (z0 + m * (z1 - z0)) / par.scale;
                double theta = Math.asin(d * Math.sin(gammap) / R);
                double mu = 0.0;
                if (theta < par.anglelimit) {
                    double thetap = Math.asin(n1 * Math.sin(theta) / n2);
                    double Tp2 = Math.pow(2.0 * Math.sin(thetap) * Math.cos(theta) * 2.0 * Math.sin(theta) * Math.cos(thetap), 2.0) / Math.pow(Math.sin(thetap + theta) * Math.cos(thetap - theta), 4.0);
                    double Ts2 = Math.pow(2.0 * Math.sin(thetap) * Math.cos(theta) * 2.0 * Math.sin(theta) * Math.cos(thetap), 2.0) / Math.pow(Math.sin(theta + thetap), 4.0);
                    double Rp = Math.pow(Math.tan(thetap - theta) / Math.tan(thetap + theta), 2.0);
                    double Rs = Math.pow(Math.sin(thetap - theta) / Math.sin(thetap + theta), 2.0);
                    double fp = par.fp;
                    double fs = par.fs;
                    double Qsp = 1.0 + Rp * Math.cos(2.0 * theta) - Tp2 * (Math.cos(2.0 * theta - 2.0 * thetap) + Rp * Math.cos(2.0 * theta)) / (1.0 + Rp * Rp + 2.0 * Rp * Math.cos(2.0 * thetap));
                    double Qss = 1.0 + Rs * Math.cos(2.0 * theta) - Ts2 * (Math.cos(2.0 * theta - 2.0 * thetap) + Rs * Math.cos(2.0 * theta)) / (1.0 + Rs * Rs + 2.0 * Rs * Math.cos(2.0 * thetap));
                    double Qgp = Rp * Math.sin(2.0 * theta) - Tp2 * (Math.sin(2.0 * theta - 2.0 * thetap) + Rp * Math.sin(2.0 * theta)) / (1.0 + Rp * Rp + 2.0 * Rp * Math.cos(2.0 * thetap));
                    double Qgs = Rs * Math.sin(2.0 * theta) - Ts2 * (Math.sin(2.0 * theta - 2.0 * thetap) + Rs * Math.sin(2.0 * theta)) / (1.0 + Rs * Rs + 2.0 * Rs * Math.cos(2.0 * thetap));
                    double Qs = fp * Qsp + fs * Qss;
                    double Qg = fp * Qgp + fs * Qgs;
                    Qsx = -Qs * Math.cos(alpha) * Math.sin(beta);
                    Qsy = -Qs * Math.cos(alpha) * Math.cos(beta);
                    Qsz = Qs * Math.sin(alpha);
                    Qgx = Qg * (Math.cos(mu) * Math.sin(alpha) * Math.sin(beta) - Math.sin(mu) * Math.cos(beta));
                    Qgy = Qg * (Math.cos(mu) * Math.sin(alpha) * Math.cos(beta) + Math.sin(mu) * Math.sin(beta));
                    Qgz = Qg * Math.cos(mu) * Math.cos(alpha);
                } else {
                    Qsx = 0.0;
                    Qsy = 0.0;
                    Qsz = 0.0;
                    Qgx = 0.0;
                    Qgy = 0.0;
                    Qgz = 0.0;
                }
            } else {
                Qsx = 0.0;
                Qsy = 0.0;
                Qsz = 0.0;
                Qgx = 0.0;
                Qgy = 0.0;
                Qgz = 0.0;
            }
            Qx = Qsx + Qgx;
            Qy = Qsy + Qgy;
            Qz = Qsz + Qgz;
            if (Qx != Qx & Qy != Qy & Qz != Qz) {
                raigs.dF[k] = 0.0;
                continue;
            }
            double dF = p[k] * par.n1 / par.c;
            raigs.dF[k] = dF * Math.sqrt(Qx * Qx + Qy * Qy + Qz * Qz);
            Q[0][0] = Q[0][0] + Qx * dF;
            Q[0][1] = Q[0][1] + Qy * dF;
            Q[0][2] = Q[0][2] + Qz * dF;
            Q[1][0] = Q[1][0] + Qsx * dF;
            Q[1][1] = Q[1][1] + Qsy * dF;
            Q[1][2] = Q[1][2] + Qsz * dF;
            Q[2][0] = Q[2][0] + Qgx * dF;
            Q[2][1] = Q[2][1] + Qgy * dF;
            Q[2][2] = Q[2][2] + Qgz * dF;
        }
        return Q;
    }

    public double[][] calcRayleigh(Parametres par, GaussianBeam gb, double xc, double yc, double zc) {
        double[][] F = new double[3][3];
        double m = par.n2 / par.n1;
        double w0 = par.w0;
        double c = par.c;
        double a = par.R;
        double P = par.P;
        double nmedi = par.n1;
        double ct = (m * m - 1.0) / (m * m + 2.0);
        double kmedi = par.kmedi;
        double x = xc / w0;
        double y = yc / w0;
        double z = zc / (kmedi * w0 * w0);
        double coefxy = P / (Math.PI * w0 * w0) / (1.0 + 4.0 * z * z) * Math.exp(-2.0 * (x * x + y * y) / (1.0 + 4.0 * z * z));
        F[1][0] = 0.0;
        F[1][1] = 0.0;
        F[1][2] = nmedi / c * 8.0 / 3.0 * Math.PI * Math.pow(kmedi * a, 4.0) * Math.pow(a * ct, 2.0) * 2.0 * coefxy;
        F[2][0] = Math.PI * -2 * nmedi * Math.pow(a, 3.0) / c * ct * 4.0 * x / w0 / (1.0 + Math.pow(2.0 * z, 2.0)) * coefxy;
        F[2][1] = Math.PI * -2 * nmedi * Math.pow(a, 3.0) / c * ct * 4.0 * y / w0 / (1.0 + Math.pow(2.0 * z, 2.0)) * coefxy;
        F[2][2] = Math.PI * -2 * nmedi * Math.pow(a, 3.0) / c * ct * 8.0 * z / (kmedi * w0 * w0) / (1.0 + 4.0 * z * z) * (1.0 - 2.0 * (x * x + y * y) / (1.0 + 4.0 * z * z)) * 2.0 * coefxy;
        F[0][0] = F[1][0] + F[2][0];
        F[0][1] = F[1][1] + F[2][1];
        F[0][2] = F[1][2] + F[2][2];
        return F;
    }

    public double[] molla(Parametres par, double x, double y, double z) {
        double[] F = new double[]{-x, -y, -z};
        return F;
    }

    public double[][] measuredforce(Parametres par, double x, double y, double z, double[] angleout) {
        double[] Tp = new double[par.Nraigd];
        double[] Ts = new double[par.Nraigd];
        Raigs raigsm = new Raigs(par);
        double T0 = 4.0 * par.n1 * par.n2 / Math.pow(par.n1 + par.n2, 2.0);
        for (int k = 0; k < par.Nraigd; ++k) {
            double theta = angleout[k];
            double thetap = Math.asin(par.n1 * Math.sin(theta) / par.n2);
            Tp[k] = Math.pow(2.0 * Math.sin(thetap) * Math.cos(theta) * 2.0 * Math.sin(theta) * Math.cos(thetap), 2.0) / Math.pow(Math.sin(thetap + theta) * Math.cos(thetap - theta), 4.0) / T0;
            Ts[k] = Math.pow(2.0 * Math.sin(thetap) * Math.cos(theta) * 2.0 * Math.sin(theta) * Math.cos(thetap), 2.0) / Math.pow(Math.sin(theta + thetap), 4.0) / T0;
            boolean h = true;
            raigsm.p[k] = raigsm.power[k] * (par.fp * Math.pow(Tp[k], (double)h) + par.fs * Math.pow(Ts[k], (double)h));
        }
        double[][] Fm = this.calcMie(par, raigsm, x, y, z);
        return Fm;
    }

    private void jbInit() throws Exception {
    }
}

