/*
 * Decompiled with CFR 0.152.
 */
package tweezers;

import java.awt.Label;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display2d.VectorPlot;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import tweezers.Captions;
import tweezers.Forces;
import tweezers.GaussianBeam;
import tweezers.Parametres;
import tweezers.Raigs;

public class Camp {
    Captions cap = new Captions();
    Forces forces = new Forces();
    GaussianBeam gb = new GaussianBeam();
    double[][] F;
    double fmax;

    public void calc(PlottingPanel plottingpanelcamp, DrawingPanel legend, Label[] labels, Raigs raigs, Parametres par) {
        int N = 20;
        double discret = 5.0 / (double)N;
        double[][][] data = new double[2][N][N + 1];
        VectorPlot plot = new VectorPlot();
        int q = par.q;
        double smax = par.fieldforces[par.regim] / 2.0 / par.scale;
        plot.setAll(data, -smax, smax, -smax, smax);
        plot.setPaletteType(0);
        String s = "";
        if (q == 0) {
            s = "(For\ufffda Total)";
        }
        if (q == 1) {
            s = "(For\ufffda de scattering)";
        }
        if (q == 2) {
            s = "(For\ufffda de gradient)";
        }
        this.fmax = 0.0;
        double modF = 0.0;
        int Nmax = N;
        for (int i = 0; i < N; ++i) {
            double yc = plot.indexToX(i);
            for (int j = 0; j <= N; ++j) {
                double zc = plot.indexToY(j);
                this.F = this.forces.calc(par, raigs, 0.0, yc * par.scale, zc * par.scale);
                data[0][i][j] = this.F[q][1] * 1.0E12;
                data[1][i][j] = this.F[q][2] * 1.0E12;
                modF = Math.sqrt(this.F[q][1] * this.F[q][1] + this.F[q][2] * this.F[q][2]);
                if (!(modF > this.fmax)) continue;
                this.fmax = modF;
            }
        }
        plot.setAll(data, -smax, smax, -smax, smax);
        plottingpanelcamp.clear();
        plottingpanelcamp.setSquareAspect(false);
        plottingpanelcamp.setAutoscaleX(true);
        plottingpanelcamp.setAutoscaleY(true);
        plottingpanelcamp.addDrawable(plot);
        plottingpanelcamp.repaint();
        plottingpanelcamp.setXLabel(this.cap.forceFieldXlabel[par.lang]);
        plottingpanelcamp.setYLabel(this.cap.forceFieldYlabel[par.lang]);
        String imagename = "legend.png";
        Resource res = ResourceLoader.getResource(imagename);
        MeasuredImage mi = new MeasuredImage(res.getBufferedImage(), -1.0, 1.0, -1.0, 1.0);
        legend.addDrawable(mi);
        legend.repaint();
        DecimalFormat df = new DecimalFormat("0.00");
        this.fmax *= Math.pow(10.0, 12.0);
        labels[0].setText("F=" + df.format(0.0) + "pN");
        labels[1].setText("F=" + df.format(this.fmax / 4.0) + "pN");
        labels[2].setText("F=" + df.format(this.fmax / 2.0) + "pN");
        labels[3].setText("F=" + df.format(this.fmax * 3.0 / 4.0) + "pN");
        labels[4].setText("F=" + df.format(this.fmax) + "pN");
        plottingpanelcamp.setShowCoordinates(true);
        plottingpanelcamp.repaint();
    }
}

